/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.Compressor;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class DocumentLists {
    private static final int RANGE = 1024;
    private static final int NConcepts = 16;
    private static final int K = 3;
    private final IntegerArray[] _arrays = new IntegerArray[1024];
    private int _minConcept = 0;
    private int _limit = 1024;
    private final IntegerArray _concepts = new IntegerArray();
    private final IntegerArray _offsets = new IntegerArray();
    private final Compressor _compr = new Compressor();
    private final IntegerArray _diffs = new IntegerArray();
    private final ByteArrayDecompressor _decmp = new ByteArrayDecompressor(null, 0);
    private DataOutputStream _mainFile;
    private int _heapSize = 0;
    private MicroIndex[] _heap;
    private boolean debug = false;

    private DocumentLists(String string) throws Exception {
        int n = 0;
        while (n < 1024) {
            this._arrays[n] = new IntegerArray();
            ++n;
        }
        this._mainFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(string) + "DOCS")));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(String.valueOf(string) + "OFFSETS"));
        int n2 = ((InputStream)bufferedInputStream).read();
        IntegerArray integerArray = new IntegerArray(4096);
        StreamDecompressor streamDecompressor = new StreamDecompressor(bufferedInputStream);
        streamDecompressor.ascDecode(n2, integerArray);
        int n3 = ((InputStream)bufferedInputStream).read();
        IntegerArray integerArray2 = new IntegerArray(integerArray.cardinality() + 1);
        StreamDecompressor streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor2.ascDecode(n3, integerArray2);
        ((InputStream)bufferedInputStream).close();
        File file = new File(String.valueOf(string) + "POSITIONS");
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        this._heapSize = integerArray.cardinality();
        this._heap = new MicroIndex[this._heapSize];
        int n4 = 0;
        while (n4 < integerArray.cardinality()) {
            this._heap[n4] = new MicroIndex(n4, byArray, integerArray2.at(n4));
            ++n4;
        }
        this.debug(String.valueOf(integerArray.cardinality()) + " documents");
        int n5 = this._heapSize / 2;
        while (n5 >= 0) {
            this.heapify(n5);
            --n5;
        }
        while (true) {
            if (this._heap[0].process(this)) {
                this.heapify(0);
                continue;
            }
            if (this._heapSize <= 1) break;
            this._heap[0] = this._heap[--this._heapSize];
            this.heapify(0);
        }
        this.flush();
        this._mainFile.close();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(string) + "DOCS.TAB")));
        dataOutputStream.write(this._compr.compressAscending(this._concepts));
        this._compr.write(dataOutputStream);
        this._compr.clear();
        dataOutputStream.write(this._compr.minimize(this._offsets, 3));
        this._compr.write(dataOutputStream);
        dataOutputStream.close();
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("DocumentLists: " + string);
        }
    }

    private void flush() throws IOException {
        int n = 0;
        while (n < 1024) {
            if (this._arrays[n].cardinality() > 0) {
                this._arrays[n].toDifferences(this._diffs);
                this._mainFile.write(this._compr.minimize(this._diffs, 3));
                this._offsets.add(this._compr.byteCount() + 1);
                this._compr.write(this._mainFile);
                this._concepts.add(this._minConcept + n);
                this._arrays[n].clear();
                this._diffs.clear();
                this._compr.clear();
            }
            ++n;
        }
        this._limit += 1024;
        this._minConcept += 1024;
    }

    private void heapify(int n) {
        int n2;
        int n3 = n + 1 << 1;
        int n4 = n3 - 1;
        int n5 = n2 = n4 < this._heapSize && this._heap[n4].smallerThan(this._heap[n]) ? n4 : n;
        if (n3 < this._heapSize && this._heap[n3].smallerThan(this._heap[n2])) {
            n2 = n3;
        }
        if (n2 != n) {
            MicroIndex microIndex = this._heap[n2];
            this._heap[n2] = this._heap[n];
            this._heap[n] = microIndex;
            this.heapify(n2);
        }
    }

    public static void invert(String string) throws Exception {
        new DocumentLists(string);
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            new DocumentLists(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public short process(int n, int[] nArray, int n2, short s, boolean bl) throws IOException {
        if (bl && nArray[s] >= this._limit) {
            this.flush();
        }
        nArray[n2] = this._limit;
        while (nArray[s] < this._limit) {
            short s2 = s;
            s = (short)(s2 + 1);
            this._arrays[nArray[s2] - this._minConcept].add(n);
        }
        return s;
    }

    private class MicroIndex {
        private int _currentRange;
        private final int _documentNumber;
        private int[] _concepts = new int[17];
        private short _group;
        private short _ix;
        private IntegerArray _kTable = new IntegerArray();
        private IntegerArray _offsets = new IntegerArray();
        private IntegerArray _maxConcepts = new IntegerArray();
        private byte[] _data;
        private int _base;
        private int _limit;
        private int _nc;

        public MicroIndex(int n, byte[] byArray, int n2) throws Exception {
            this._documentNumber = n;
            this._data = byArray;
            this._base = n2;
            this.openDocumentIndex();
        }

        private boolean next() throws Exception {
            if (this._group <= this._limit) {
                int n;
                int n2;
                if (this._group > 0) {
                    n2 = this._base + this._offsets.at(this._group - 1);
                    n = this._maxConcepts.at(this._group - 1);
                } else {
                    n2 = this._base;
                    n = 0;
                }
                DocumentLists.this._decmp.initReading(this._data, n2);
                this._nc = DocumentLists.this._decmp.ascendingDecode(this._kTable.at(this._group * 2), n, this._concepts);
                if (this._group < this._limit) {
                    this._concepts[this._nc++] = this._maxConcepts.at(this._group);
                }
                this._ix = 0;
                this._currentRange = this._concepts[0] / 1024;
                this._group = (short)(this._group + 1);
                return true;
            }
            return false;
        }

        private void openDocumentIndex() throws Exception {
            int n = this._data[this._base] & 0xFF;
            switch (n >> 6) {
                case 0: {
                    DocumentLists.this._decmp.initReading(this._data, this._base += 2);
                    this._nc = DocumentLists.this._decmp.ascendingDecode(n & 0x3F, 0, this._concepts);
                    this._ix = 0;
                    this._currentRange = this._concepts[0] / 1024;
                    this._limit = 0;
                    this._group = 1;
                    break;
                }
                case 2: {
                    DocumentLists.this._decmp.initReading(this._data, this._base + 1);
                    DocumentLists.this._decmp.decode(n & 0x3F, this._kTable);
                    DocumentLists.this._decmp.ascDecode(this._kTable.popLast(), this._offsets);
                    DocumentLists.this._decmp.ascDecode(this._kTable.popLast(), this._maxConcepts);
                    this._base += 1 + DocumentLists.this._decmp.bytesRead();
                    this._limit = this._maxConcepts.cardinality();
                    this._group = 0;
                    this.next();
                    break;
                }
                case 1: 
                case 3: {
                    System.err.println("extents not yet implemented\n");
                    break;
                }
            }
        }

        public boolean process(DocumentLists documentLists) throws Exception {
            boolean bl = true;
            while (true) {
                short s;
                if ((s = documentLists.process(this._documentNumber, this._concepts, this._nc, this._ix, bl)) < this._nc) {
                    this._ix = s;
                    this._currentRange = this._concepts[this._ix] / 1024;
                    return true;
                }
                if (!this.next()) break;
                bl = false;
            }
            return false;
        }

        public boolean smallerThan(MicroIndex microIndex) {
            return this._currentRange < microIndex._currentRange || this._currentRange == microIndex._currentRange && this._documentNumber < microIndex._documentNumber;
        }
    }
}

