/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.omegahat.Environment.DataStructures.Addable;
import org.omegahat.Environment.DataStructures.Divisable;
import org.omegahat.Environment.DataStructures.Multiplicable;
import org.omegahat.Environment.DataStructures.Subtractable;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Interpreter.DynamicFieldAccessInt;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Language.Function;
import org.omegahat.Environment.Parser.Parse.ArrayAccess;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.FieldAccess;
import org.omegahat.Environment.Parser.Parse.LocalVariable;
import org.omegahat.Environment.Parser.Parse.Name;
import org.omegahat.Environment.Parser.Parse.NumberExpression;
import org.omegahat.Environment.Parser.Parse.OperatorExpression;

public class AssignExpression
extends OperatorExpression {
    protected String name = null;
    protected int database_id = -1;
    protected Database database = null;

    public AssignExpression(Object object, Object object2) {
        super(object, object2, 85);
    }

    public AssignExpression(Object object, Object object2, int n) {
        super(object, object2, n);
    }

    public AssignExpression(Object object, Object object2, Integer n) {
        this(object, object2, (int)n);
    }

    public boolean arrayAssignment() {
        return this.element(0) instanceof ArrayAccess;
    }

    public Object arrayOperation(Object object, Object object2, Evaluator evaluator) {
        Object object3 = object;
        boolean bl = object.getClass().isArray();
        boolean bl2 = object2.getClass().isArray();
        if (!bl) {
            object3 = object2;
        }
        Class<?> clazz = object3.getClass().getComponentType();
        int n = bl ? Array.getLength(object) : 1;
        int n2 = object2.getClass().isArray() ? Array.getLength(object2) : 1;
        int n3 = Math.max(n, n2);
        Object object4 = object;
        Object[] objectArray = new Object[2];
        int n4 = 0;
        while (n4 < n3) {
            objectArray[0] = bl ? Array.get(object, n4 % n) : object;
            objectArray[1] = bl2 ? Array.get(object, n4 % n2) : object2;
            Object object5 = this.numericComputation(objectArray);
            Array.set(object4, n4, object5);
            ++n4;
        }
        return object4;
    }

    public double computeNumeric(double[] dArray) {
        switch (this.operator()) {
            case 110: 
            case 136: {
                dArray[0] = dArray[0] + dArray[1];
                break;
            }
            case 111: 
            case 137: {
                dArray[0] = dArray[0] - dArray[1];
                break;
            }
            case 74: 
            case 112: {
                dArray[0] = dArray[0] * dArray[1];
                break;
            }
            case 113: 
            case 138: {
                dArray[0] = dArray[0] / dArray[1];
                break;
            }
            case 114: 
            case 141: {
                dArray[0] = dArray[0] % dArray[1];
                break;
            }
            case 119: 
            case 140: {
                dArray[0] = Math.pow(dArray[0], dArray[1]);
                break;
            }
            default: {
                throw new RuntimeException("Don't recognize this operation in AssignExpression " + this.separator() + " " + this.operator());
            }
        }
        return dArray[0];
    }

    public Database database() {
        return this.database;
    }

    public Database database(Database database) {
        this.database = database;
        return this.database();
    }

    public int databaseId() {
        return this.database_id;
    }

    public int databaseId(int n) {
        this.database_id = n;
        return this.databaseId();
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        this.name = null;
        if (evaluator.Debug(this)) {
            System.out.println("Assign " + this.element(0).getClass().getName() + " " + this.element(1));
        }
        Object var3_2 = null;
        Object var4_3 = null;
        if (this.arrayAssignment()) {
            System.err.println("This should never have happened anymore. You should have an ArrayAccessAssignExpression. Please mail the input to omega-devel@omegahat.org");
            throw new RuntimeException();
        }
        Object object = this.element(1) instanceof ExpressionInt ? ((ExpressionInt)this.element(1)).eval(evaluator) : this.element(1);
        if (this.element(0) instanceof FieldAccess) {
            object = this.setField((FieldAccess)this.element(0), object, evaluator);
        } else {
            Object object2;
            this.name = this.getName(evaluator);
            Database database = this.database();
            if (database == null && (database = this.getDatabase(this.name, evaluator)) == null) {
                database = evaluator.defaultDatabase();
            }
            if ((object = this.operate(object2 = database.get(this.name), object, evaluator)) instanceof Function) {
                ((Function)object).name(this.name);
            }
            if (!evaluator.assign(this.name, object, database)) {
                object = null;
            }
        }
        return object;
    }

    protected Database getDatabase(String string, Evaluator evaluator) {
        if (this.parent() != null && this.parent() instanceof LocalVariable) {
            return evaluator.defaultDatabase();
        }
        if (this.database() != null) {
            return this.database();
        }
        if (this.databaseId() > -1) {
            this.database((Database)evaluator.searchPath().elementAt(this.databaseId()));
            return this.database();
        }
        return evaluator.which(string);
    }

    public String getName(Evaluator evaluator) throws Throwable {
        if (this.name != null) {
            return this.name;
        }
        if (this.element(0) instanceof Name) {
            this.name = ((Name)this.element(0)).asString();
        } else if (this.element(0) instanceof ExpressionInt) {
            Object object = ((ExpressionInt)this.element(0)).eval(evaluator);
            if (object == null) {
                throw new Exception();
            }
            this.name = object.toString();
        } else {
            this.name = this.element(0).toString();
        }
        return this.name;
    }

    public boolean isMathOperation() {
        int n = this.operator();
        return n == 110 || n == 111 || n == 113 || n == 112;
    }

    public Object numericComputation(Object[] objectArray) {
        double[] dArray = new double[2];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = NumberExpression.asNumber(objectArray[n]);
            ++n;
        }
        dArray[0] = this.computeNumeric(dArray);
        Object object = this.toNumber(dArray[0], objectArray);
        return object;
    }

    public Object operate(Object object, Object object2, Evaluator evaluator) {
        Object object3 = null;
        Object[] objectArray = new Object[]{object, object2};
        double d = 0.0;
        int n = 0;
        if (this.operator() != 85 && object != null && object2 != null && (object.getClass().isArray() || object2.getClass().isArray())) {
            return this.arrayOperation(object, object2, evaluator);
        }
        if (this.isMathOperation()) {
            boolean bl = false;
            switch (this.operator()) {
                case 110: {
                    if (!(object instanceof Addable)) break;
                    object3 = ((Addable)object).addValue(object2, true);
                    bl = true;
                    break;
                }
                case 111: {
                    if (!(object instanceof Subtractable)) break;
                    object3 = ((Subtractable)object).subtractValue(object2, true);
                    bl = true;
                    break;
                }
                case 112: {
                    if (!(object instanceof Multiplicable)) break;
                    object3 = ((Multiplicable)object).multiplyValue(object2, true);
                    bl = true;
                    break;
                }
                case 113: {
                    if (!(object instanceof Divisable)) break;
                    object3 = ((Divisable)object).divideValue(object2, true);
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                return object3;
            }
        }
        switch (this.operator()) {
            case 85: {
                object3 = object2;
                break;
            }
            case 110: {
                if (object instanceof String) {
                    object3 = String.valueOf((String)object) + object2;
                    break;
                }
                d = NumberExpression.asNumber(object) + NumberExpression.asNumber(object2);
                object3 = this.toNumber(d, objectArray);
                break;
            }
            case 112: {
                d = NumberExpression.asNumber(object) * NumberExpression.asNumber(object2);
                object3 = this.toNumber(d, objectArray);
                break;
            }
            case 111: {
                d = NumberExpression.asNumber(object) - NumberExpression.asNumber(object2);
                object3 = this.toNumber(d, objectArray);
                break;
            }
            case 113: {
                d = NumberExpression.asNumber(object) / NumberExpression.asNumber(object2);
                object3 = this.toNumber(d, objectArray);
                break;
            }
            case 114: {
                n = this.asInt(object) % this.asInt(object2);
                object3 = this.toInteger(n);
                break;
            }
            case 120: {
                n = this.asInt(object) | this.asInt(object2);
                object3 = this.toInteger(n);
                break;
            }
            case 118: {
                n = this.asInt(object) & this.asInt(object2);
                object3 = this.toInteger(n);
                break;
            }
            case 119: {
                n = this.asInt(object) ^ this.asInt(object2);
                object3 = this.toInteger(n);
                break;
            }
            case 117: {
                n = this.asInt(object) << this.asInt(object2);
                object3 = this.toInteger(n);
                break;
            }
            case 115: {
                n = this.asInt(object) >> this.asInt(object2);
                object3 = this.toInteger(n);
                break;
            }
            case 116: {
                n = this.asInt(object) >>> this.asInt(object2);
                object3 = this.toInteger(n);
                break;
            }
        }
        return object3;
    }

    public Object setField(FieldAccess fieldAccess, Object object, Evaluator evaluator) throws Throwable {
        Object object2 = null;
        NoSuchFieldException noSuchFieldException = null;
        Field field = null;
        try {
            field = fieldAccess.getField(evaluator);
        }
        catch (NoSuchFieldException noSuchFieldException2) {
            noSuchFieldException = noSuchFieldException2;
        }
        object2 = fieldAccess.qualifier().eval(evaluator);
        if ((field == null || !Modifier.isPublic(field.getModifiers())) && object2 instanceof DynamicFieldAccessInt) {
            ((DynamicFieldAccessInt)object2).setDynamicField(fieldAccess.elementName(), object);
            return object;
        }
        if (field == null) {
            throw noSuchFieldException;
        }
        field.set(object2, object);
        return object;
    }
}

