/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.ExceptionHandler;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaBlockFinishingInfo;
import antlr.JavaCharFormatter;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.SynPredBlock;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class JavaCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel;
    protected boolean genAST = false;
    protected boolean saveText = false;
    String labeledElementType;
    String labeledElementASTType;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    RuleBlock currentRule;
    String currentASTResult;
    Hashtable treeVariableMap = new Hashtable();
    int astVarNumber = 1;
    protected static final String NONUNIQUE = new String();
    private Vector semPreds;

    public JavaCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    protected int addSemPred(String string) {
        this.semPreds.appendElement(string);
        return this.semPreds.size() - 1;
    }

    public void exitIfError() {
        if (this.tool.hasError) {
            System.out.println("Exiting due to errors.");
            System.exit(1);
        }
    }

    public void gen() {
        try {
            Object object;
            Enumeration enumeration = this.behavior.grammars.elements();
            while (enumeration.hasMoreElements()) {
                object = (Grammar)enumeration.nextElement();
                ((Grammar)object).setGrammarAnalyzer(this.analyzer);
                ((Grammar)object).setCodeGenerator(this);
                this.analyzer.setGrammar((Grammar)object);
                this.setupGrammarParameters((Grammar)object);
                ((Grammar)object).generate();
                this.exitIfError();
            }
            object = this.behavior.tokenManagers.elements();
            while (object.hasMoreElements()) {
                TokenManager tokenManager = (TokenManager)object.nextElement();
                if (!tokenManager.isReadOnly()) {
                    this.genTokenTypes(tokenManager);
                    this.genTokenInterchange(tokenManager);
                }
                this.exitIfError();
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
    }

    public void gen(ActionElement actionElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAction(" + actionElement + ")");
        }
        if (actionElement.isSemPred) {
            this.genSemPred(actionElement.actionText);
            return;
        }
        if (this.grammar.hasSyntacticPredicate) {
            this.println("if ( guessing==0 ) {");
            ++this.tabs;
        }
        ActionTransInfo actionTransInfo = new ActionTransInfo();
        String string = this.processActionForTreeSpecifiers(actionElement.actionText, actionElement.getLine(), this.currentRule, actionTransInfo);
        if (actionTransInfo.refRuleRoot != null) {
            this.println(String.valueOf(actionTransInfo.refRuleRoot) + " = (" + this.labeledElementASTType + ")currentAST.root;");
        }
        this.printAction(string);
        if (actionTransInfo.assignToRoot) {
            this.println("currentAST.root = " + actionTransInfo.refRuleRoot + ";");
            this.println("currentAST.child = " + actionTransInfo.refRuleRoot + "!=null &&" + actionTransInfo.refRuleRoot + ".getFirstChild()!=null ?");
            ++this.tabs;
            this.println(String.valueOf(actionTransInfo.refRuleRoot) + ".getFirstChild() : " + actionTransInfo.refRuleRoot + ";");
            --this.tabs;
            this.println("currentAST.advanceChildToEnd();");
        }
        if (this.grammar.hasSyntacticPredicate) {
            --this.tabs;
            this.println("}");
        }
    }

    public void gen(AlternativeBlock alternativeBlock) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + alternativeBlock + ")");
        }
        this.println("{");
        this.genBlockPreamble(alternativeBlock);
        String string = this.currentASTResult;
        if (alternativeBlock.getLabel() != null) {
            this.currentASTResult = alternativeBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(alternativeBlock);
        JavaBlockFinishingInfo javaBlockFinishingInfo = this.genCommonBlock(alternativeBlock, true);
        this.genBlockFinish(javaBlockFinishingInfo, this.throwNoViable);
        this.println("}");
        this.currentASTResult = string;
    }

    public void gen(BlockEndElement blockEndElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + blockEndElement + ")");
        }
    }

    public void gen(CharLiteralElement charLiteralElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + charLiteralElement + ")");
        }
        if (charLiteralElement.getLabel() != null) {
            this.println(String.valueOf(charLiteralElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        boolean bl = this.saveText;
        this.saveText = this.saveText && charLiteralElement.getAutoGenType() == 1;
        this.genMatch(charLiteralElement);
        this.saveText = bl;
    }

    public void gen(CharRangeElement charRangeElement) {
        if (charRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(charRangeElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.println("matchRange(" + charRangeElement.beginText + "," + charRangeElement.endText + ");");
    }

    public void gen(LexerGrammar lexerGrammar) throws IOException {
        GrammarSymbol grammarSymbol;
        GrammarSymbol grammarSymbol2;
        Object object;
        if (lexerGrammar.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(lexerGrammar);
        if (!(this.grammar instanceof LexerGrammar)) {
            Tool.panic("Internal error generating lexer");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println("import java.io.InputStream;");
        this.println("import java.io.Reader;");
        this.println("import java.io.IOException;");
        this.println("import java.util.Hashtable;");
        this.println("import antlr." + this.grammar.getSuperClass() + ";");
        this.println("import antlr.InputBuffer;");
        this.println("import antlr.ByteBuffer;");
        this.println("import antlr.CharBuffer;");
        this.println("import antlr.Token;");
        this.println("import antlr.CommonToken;");
        this.println("import antlr.ScannerException;");
        this.println("import antlr.Tokenizer;");
        this.println("import antlr.ANTLRHashString;");
        this.println("import antlr.collections.impl.BitSet;");
        this.println(this.grammar.preambleAction);
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.print("public class " + this.grammar.getClassName() + " extends " + string);
        this.println(" implements " + this.grammar.tokenManager.getName() + "TokenTypes, Tokenizer");
        Token token = (Token)this.grammar.options.get("classHeaderSuffix");
        if (token != null && (object = Tool.stripFrontBack(token.getText(), "\"", "\"")) != null) {
            this.print(", " + (String)object);
        }
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction, 0, this.currentRule, null));
        this.println("public " + this.grammar.getClassName() + "(InputStream in) {");
        ++this.tabs;
        this.println("this(new ByteBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(Reader in) {");
        ++this.tabs;
        this.println("this(new CharBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(InputBuffer ib) {");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println("super(new antlr.debug.DebuggingInputBuffer(ib));");
        } else {
            this.println("super(ib);");
        }
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging();");
        }
        this.println("literals = new Hashtable();");
        object = this.grammar.tokenManager.getTokenSymbolElements();
        while (object.hasMoreElements()) {
            grammarSymbol2 = (TokenSymbol)object.nextElement();
            if (!(grammarSymbol2 instanceof StringLiteralSymbol)) continue;
            grammarSymbol = (StringLiteralSymbol)grammarSymbol2;
            this.println("literals.put(new ANTLRHashString(" + grammarSymbol.getId() + ", this), new Integer(" + ((TokenSymbol)grammarSymbol).getTokenType() + "));");
        }
        --this.tabs;
        this.println("caseSensitiveLiterals = " + lexerGrammar.caseSensitiveLiterals + ";");
        this.println("setCaseSensitive(" + lexerGrammar.caseSensitive + ");");
        this.println("}");
        if (this.grammar.debuggingOutput) {
            this.println("private static final String _ruleNames[] = {");
            object = this.grammar.rules.elements();
            while (object.hasMoreElements()) {
                grammarSymbol2 = (GrammarSymbol)object.nextElement();
                if (!(grammarSymbol2 instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)grammarSymbol2).getId() + "\",");
            }
            this.println("};");
        }
        this.genNextToken();
        object = this.grammar.rules.elements();
        int n = 0;
        while (object.hasMoreElements()) {
            grammarSymbol = (RuleSymbol)object.nextElement();
            if (!grammarSymbol.getId().equals("mnextToken")) {
                this.genRule((RuleSymbol)grammarSymbol, false, n++);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(OneOrMoreBlock oneOrMoreBlock) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen+(" + oneOrMoreBlock + ")");
        }
        this.println("{");
        this.genBlockPreamble(oneOrMoreBlock);
        String string = oneOrMoreBlock.getLabel() != null ? "_cnt_" + oneOrMoreBlock.getLabel() : "_cnt" + oneOrMoreBlock.ID;
        this.println("int " + string + "=0;");
        String string2 = oneOrMoreBlock.getLabel() != null ? oneOrMoreBlock.getLabel() : "_loop" + oneOrMoreBlock.ID;
        this.println(String.valueOf(string2) + ":");
        this.println("do {");
        ++this.tabs;
        String string3 = this.currentASTResult;
        if (oneOrMoreBlock.getLabel() != null) {
            this.currentASTResult = oneOrMoreBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(oneOrMoreBlock);
        JavaBlockFinishingInfo javaBlockFinishingInfo = this.genCommonBlock(oneOrMoreBlock, false);
        this.genBlockFinish(javaBlockFinishingInfo, "if ( " + string + ">=1 ) { break " + string2 + "; } else {" + this.throwNoViable + "}");
        this.println(String.valueOf(string) + "++;");
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = string3;
    }

    public void gen(ParserGrammar parserGrammar) throws IOException {
        Object object;
        if (parserGrammar.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(parserGrammar);
        if (!(this.grammar instanceof ParserGrammar)) {
            Tool.panic("Internal error generating parser");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println("import java.io.IOException;");
        this.println("import antlr.Tokenizer;");
        this.println("import antlr.TokenBuffer;");
        this.println("import antlr." + this.grammar.getSuperClass() + ";");
        this.println("import antlr.Token;");
        this.println("import antlr.ParserException;");
        this.println("import antlr.NoViableAltException;");
        this.println("import antlr.MismatchedTokenException;");
        this.println("import antlr.SemanticException;");
        this.println("import antlr.collections.impl.BitSet;");
        if (this.grammar.buildAST) {
            this.println("import antlr.collections.AST;");
            this.println("import antlr.ASTPair;");
            this.println("import antlr.collections.impl.ASTArray;");
        }
        this.println(this.grammar.preambleAction);
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("public class " + this.grammar.getClassName() + " extends " + string);
        this.println("       implements " + this.grammar.tokenManager.getName() + "TokenTypes");
        Token token = (Token)this.grammar.options.get("classHeaderSuffix");
        if (token != null && (object = Tool.stripFrontBack(token.getText(), "\"", "\"")) != null) {
            this.print(", " + (String)object);
        }
        this.println(" {");
        if (this.grammar.debuggingOutput) {
            this.println("private static final String _ruleNames[] = {");
            object = this.grammar.rules.elements();
            while (object.hasMoreElements()) {
                GrammarSymbol grammarSymbol = (GrammarSymbol)object.nextElement();
                if (!(grammarSymbol instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)grammarSymbol).getId() + "\",");
            }
            this.println("};");
        }
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction, 0, this.currentRule, null));
        this.println("");
        this.println("protected " + this.grammar.getClassName() + "(TokenBuffer tokenBuf, int k) {");
        this.println("  super(tokenBuf,k);");
        this.println("  tokenNames = _tokenNames;");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging(null);");
        }
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(TokenBuffer tokenBuf) {");
        this.println("  this(tokenBuf," + this.grammar.maxk + ");");
        this.println("}");
        this.println("");
        this.println("protected " + this.grammar.getClassName() + "(Tokenizer lexer, int k) {");
        this.println("  super(lexer,k);");
        this.println("  tokenNames = _tokenNames;");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging(lexer);");
        }
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(Tokenizer lexer) {");
        this.println("  this(lexer," + this.grammar.maxk + ");");
        this.println("}");
        this.println("");
        object = this.grammar.rules.elements();
        int n = 0;
        while (object.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)object.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                this.genRule(ruleSymbol, ruleSymbol.references.size() == 0, n++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement ruleRefElement) {
        RuleSymbol ruleSymbol;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + ruleRefElement + ")");
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule)) == null || !ruleSymbol.isDefined()) {
            this.tool.error("Rule '" + ruleRefElement.targetRule + "' is not defined", ruleRefElement.getLine());
            return;
        }
        if (!(ruleSymbol instanceof RuleSymbol)) {
            this.tool.error("'" + ruleRefElement.targetRule + "' does not name a grammar rule", ruleRefElement.getLine());
            return;
        }
        this.genErrorTryForElement(ruleRefElement);
        if (this.grammar instanceof TreeWalkerGrammar && ruleRefElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(ruleRefElement.getLabel()) + " = _t==ASTNULL ? null : " + this.lt1Value + ";");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || ruleRefElement.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.printTabs();
        if (ruleRefElement.idAssign != null) {
            if (ruleSymbol.block.returnAction == null) {
                Tool.warning("Rule '" + ruleRefElement.targetRule + "' has no return type", ruleRefElement.getLine());
            }
            this._print(String.valueOf(ruleRefElement.idAssign) + "=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && ruleSymbol.block.returnAction != null) {
            Tool.warning("Rule '" + ruleRefElement.targetRule + "' returns a value", ruleRefElement.getLine());
        }
        this.GenRuleInvocation(ruleRefElement);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || ruleRefElement.getAutoGenType() == 3)) {
            this.println("text.setLength(_saveIndex);");
        }
        if (this.syntacticPredLevel == 0) {
            boolean bl;
            boolean bl2 = bl = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && ruleRefElement.getLabel() != null || this.genAST && ruleRefElement.getAutoGenType() == 1);
            if (bl) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            if (this.grammar.buildAST && ruleRefElement.getLabel() != null) {
                this.println(String.valueOf(ruleRefElement.getLabel()) + "_AST = (" + this.labeledElementASTType + ")returnAST;");
            }
            if (this.genAST) {
                switch (ruleRefElement.getAutoGenType()) {
                    case 1: {
                        this.println("astFactory.addASTChild(currentAST, returnAST);");
                        break;
                    }
                    case 2: {
                        this.tool.error("Internal: encountered ^ after rule reference");
                        break;
                    }
                }
            }
            if (this.grammar instanceof LexerGrammar && ruleRefElement.getLabel() != null) {
                this.println(String.valueOf(ruleRefElement.getLabel()) + "=_returnToken;");
            }
            if (bl) {
                --this.tabs;
                this.println("}");
            }
        }
        this.genErrorCatchForElement(ruleRefElement);
    }

    public void gen(StringLiteralElement stringLiteralElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + stringLiteralElement + ")");
        }
        if (stringLiteralElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(stringLiteralElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(stringLiteralElement);
        boolean bl = this.saveText;
        this.saveText = this.saveText && stringLiteralElement.getAutoGenType() == 1;
        this.genMatch(stringLiteralElement);
        this.saveText = bl;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    public void gen(TokenRangeElement tokenRangeElement) {
        this.genErrorTryForElement(tokenRangeElement);
        if (tokenRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(tokenRangeElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(tokenRangeElement);
        this.println("matchRange(" + tokenRangeElement.beginText + "," + tokenRangeElement.endText + ");");
        this.genErrorCatchForElement(tokenRangeElement);
    }

    public void gen(TokenRefElement tokenRefElement) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + tokenRefElement + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            Tool.panic("Token reference found in lexer");
        }
        this.genErrorTryForElement(tokenRefElement);
        if (tokenRefElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(tokenRefElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(tokenRefElement);
        this.genMatch(tokenRefElement);
        this.genErrorCatchForElement(tokenRefElement);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    public void gen(TreeElement treeElement) {
        this.println("AST __t" + treeElement.ID + " = _t;");
        if (treeElement.root.getLabel() != null) {
            this.println(String.valueOf(treeElement.root.getLabel()) + " = _t==ASTNULL ? null :(" + this.labeledElementASTType + ")_t;");
        }
        this.genElementAST(treeElement.root);
        if (this.grammar.buildAST) {
            this.println("ASTPair __currentAST" + treeElement.ID + " = currentAST.copy();");
            this.println("currentAST.root = currentAST.child;");
            this.println("currentAST.child = null;");
        }
        this.genMatch(treeElement.root);
        this.println("_t = _t.getFirstChild();");
        int n = 0;
        while (n < treeElement.getAlternatives().size()) {
            Alternative alternative = treeElement.getAlternativeAt(n);
            AlternativeElement alternativeElement = alternative.head;
            while (alternativeElement != null) {
                alternativeElement.generate();
                alternativeElement = alternativeElement.next;
            }
            ++n;
        }
        if (this.grammar.buildAST) {
            this.println("currentAST = __currentAST" + treeElement.ID + ";");
        }
        this.println("_t = __t" + treeElement.ID + ";");
        this.println("_t = _t.getNextSibling();");
    }

    public void gen(TreeWalkerGrammar treeWalkerGrammar) throws IOException {
        Object object;
        this.setGrammar(treeWalkerGrammar);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            Tool.panic("Internal error generating tree-walker");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println("import antlr." + this.grammar.getSuperClass() + ";");
        this.println("import antlr.Token;");
        this.println("import antlr.collections.AST;");
        this.println("import antlr.ParserException;");
        this.println("import antlr.NoViableAltException;");
        this.println("import antlr.MismatchedTokenException;");
        this.println("import antlr.SemanticException;");
        this.println("import antlr.collections.impl.BitSet;");
        if (this.grammar.buildAST) {
            this.println("import antlr.ASTPair;");
            this.println("import antlr.collections.impl.ASTArray;");
        }
        this.println(this.grammar.preambleAction);
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("public class " + this.grammar.getClassName() + " extends " + string);
        this.println("       implements " + this.grammar.tokenManager.getName() + "TokenTypes");
        Token token = (Token)this.grammar.options.get("classHeaderSuffix");
        if (token != null && (object = Tool.stripFrontBack(token.getText(), "\"", "\"")) != null) {
            this.print(", " + (String)object);
        }
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction, 0, this.currentRule, null));
        this.println("public " + this.grammar.getClassName() + "() {");
        ++this.tabs;
        this.println("tokenNames = _tokenNames;");
        --this.tabs;
        this.println("}");
        this.println("");
        object = this.grammar.rules.elements();
        int n = 0;
        while (object.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)object.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                this.genRule(ruleSymbol, ruleSymbol.references.size() == 0, n++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.println("}");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wildcardElement) {
        if (wildcardElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(String.valueOf(wildcardElement.getLabel()) + " = " + this.lt1Value + ";");
        }
        this.genElementAST(wildcardElement);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if ( _t==null ) throw new MismatchedTokenException();");
        } else if (this.grammar instanceof LexerGrammar) {
            this.println("matchNot(EOF_CHAR);");
        } else {
            this.println("matchNot(" + this.getValueString(1) + ");");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    public void gen(ZeroOrMoreBlock zeroOrMoreBlock) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen*(" + zeroOrMoreBlock + ")");
        }
        this.println("{");
        this.genBlockPreamble(zeroOrMoreBlock);
        String string = zeroOrMoreBlock.getLabel() != null ? zeroOrMoreBlock.getLabel() : "_loop" + zeroOrMoreBlock.ID;
        this.println(String.valueOf(string) + ":");
        this.println("do {");
        ++this.tabs;
        String string2 = this.currentASTResult;
        if (zeroOrMoreBlock.getLabel() != null) {
            this.currentASTResult = zeroOrMoreBlock.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(zeroOrMoreBlock);
        JavaBlockFinishingInfo javaBlockFinishingInfo = this.genCommonBlock(zeroOrMoreBlock, false);
        this.genBlockFinish(javaBlockFinishingInfo, "break " + string + ";");
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = string2;
    }

    protected void genAlt(Alternative alternative, AlternativeBlock alternativeBlock) {
        boolean bl = this.genAST;
        this.genAST = this.genAST && alternative.getAutoGen();
        boolean bl2 = this.saveText;
        this.saveText = this.saveText && alternative.getAutoGen();
        Hashtable hashtable = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alternative.exceptionSpec != null) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        AlternativeElement alternativeElement = alternative.head;
        while (!(alternativeElement instanceof BlockEndElement)) {
            alternativeElement.generate();
            alternativeElement = alternativeElement.next;
        }
        if (this.genAST) {
            if (alternativeBlock instanceof RuleBlock) {
                RuleBlock ruleBlock = (RuleBlock)alternativeBlock;
                this.println(String.valueOf(ruleBlock.getRuleName()) + "_AST = (" + this.labeledElementASTType + ")currentAST.root;");
            } else {
                alternativeBlock.getLabel();
            }
        }
        if (alternative.exceptionSpec != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(alternative.exceptionSpec);
        }
        this.genAST = bl;
        this.saveText = bl2;
        this.treeVariableMap = hashtable;
    }

    protected void genBitsets(Vector vector, int n) {
        this.println("");
        int n2 = 0;
        while (n2 < vector.size()) {
            BitSet bitSet = (BitSet)vector.elementAt(n2);
            bitSet.growToInclude(n);
            this.println("private static final long " + this.getBitsetName(n2) + "_data_" + "[] = { " + bitSet.toStringOfWords() + " };");
            this.println("public static final BitSet " + this.getBitsetName(n2) + " = new BitSet(" + this.getBitsetName(n2) + "_data_" + ");");
            ++n2;
        }
    }

    private void genBlockFinish(JavaBlockFinishingInfo javaBlockFinishingInfo, String string) {
        if (javaBlockFinishingInfo.needAnErrorClause && (javaBlockFinishingInfo.generatedAnIf || javaBlockFinishingInfo.generatedSwitch)) {
            if (javaBlockFinishingInfo.generatedAnIf) {
                this.println("else {");
            } else {
                this.println("{");
            }
            ++this.tabs;
            this.println(string);
            --this.tabs;
            this.println("}");
        }
        if (javaBlockFinishingInfo.postscript != null) {
            this.println(javaBlockFinishingInfo.postscript);
        }
    }

    protected void genBlockPreamble(AlternativeBlock alternativeBlock) {
        if (alternativeBlock instanceof RuleBlock) {
            RuleBlock ruleBlock = (RuleBlock)alternativeBlock;
            if (ruleBlock.labeledElements != null) {
                int n = 0;
                while (n < ruleBlock.labeledElements.size()) {
                    AlternativeElement alternativeElement = (AlternativeElement)ruleBlock.labeledElements.elementAt(n);
                    if (alternativeElement instanceof RuleRefElement || alternativeElement instanceof AlternativeBlock && !(alternativeElement instanceof RuleBlock) && !(alternativeElement instanceof SynPredBlock)) {
                        if (!(alternativeElement instanceof RuleRefElement) && ((AlternativeBlock)alternativeElement).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)alternativeElement, this.grammar instanceof LexerGrammar)) {
                            this.println(String.valueOf(this.labeledElementType) + " " + alternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
                            if (this.grammar.buildAST) {
                                this.println(String.valueOf(this.labeledElementASTType) + " " + alternativeElement.getLabel() + "_AST = null;");
                            }
                        } else {
                            if (this.grammar.buildAST) {
                                this.println(String.valueOf(this.labeledElementASTType) + " " + alternativeElement.getLabel() + "_AST = null;");
                            }
                            if (this.grammar instanceof LexerGrammar) {
                                this.println("Token " + alternativeElement.getLabel() + "=null;");
                            }
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println(String.valueOf(this.labeledElementType) + " " + alternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
                            }
                        }
                    } else {
                        this.println(String.valueOf(this.labeledElementType) + " " + alternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
                        if (this.grammar.buildAST) {
                            this.println(String.valueOf(this.labeledElementASTType) + " " + alternativeElement.getLabel() + "_AST = null;");
                        }
                    }
                    ++n;
                }
            }
        }
        if (alternativeBlock.initAction != null) {
            this.printAction(this.processActionForTreeSpecifiers(alternativeBlock.initAction, 0, this.currentRule, null));
        }
    }

    protected void genCases(BitSet bitSet) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + bitSet + ")");
        }
        int[] nArray = bitSet.toArray();
        int n = this.grammar instanceof LexerGrammar ? 4 : 1;
        int n2 = 1;
        boolean bl = true;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n2 == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            this._print("case " + this.getValueString(nArray[n3]) + ":");
            if (n2 == n) {
                this._println("");
                bl = true;
                n2 = 1;
            } else {
                ++n2;
                bl = false;
            }
            ++n3;
        }
        if (!bl) {
            this._println("");
        }
    }

    public JavaBlockFinishingInfo genCommonBlock(AlternativeBlock alternativeBlock, boolean bl) {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        JavaBlockFinishingInfo javaBlockFinishingInfo = new JavaBlockFinishingInfo();
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAltBlk(" + alternativeBlock + ")");
        }
        boolean bl3 = this.genAST;
        this.genAST = this.genAST && alternativeBlock.getAutoGen();
        boolean bl4 = this.saveText;
        boolean bl5 = this.saveText = this.saveText && alternativeBlock.getAutoGen();
        if (alternativeBlock.not && this.analyzer.subruleCanBeInverted(alternativeBlock, this.grammar instanceof LexerGrammar)) {
            Lookahead lookahead = this.analyzer.look(1, alternativeBlock);
            if (alternativeBlock.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(String.valueOf(alternativeBlock.getLabel()) + " = " + this.lt1Value + ";");
            }
            this.genElementAST(alternativeBlock);
            String string = "";
            if (this.grammar instanceof TreeWalkerGrammar) {
                string = "_t,";
            }
            this.println("match(" + string + this.getBitsetName(this.markBitsetForGen(lookahead.fset)) + ");");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("_t = _t.getNextSibling();");
            }
            return javaBlockFinishingInfo;
        }
        if (alternativeBlock.getAlternatives().size() == 1) {
            Alternative alternative = alternativeBlock.getAlternativeAt(0);
            if (alternative.synPred != null) {
                Tool.warning("Syntactic predicate superfluous for single alternative", alternativeBlock.getAlternativeAt((int)0).synPred.getLine());
            }
            if (bl) {
                if (alternative.semPred != null) {
                    this.genSemPred(alternative.semPred);
                }
                this.genAlt(alternative, alternativeBlock);
                return javaBlockFinishingInfo;
            }
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < alternativeBlock.getAlternatives().size()) {
            object3 = alternativeBlock.getAlternativeAt(n6);
            if (((Alternative)object3).lookaheadDepth == 1 && ((Alternative)object3).semPred == null && !((Alternative)object3).cache[1].containsEpsilon()) {
                ++n5;
            }
            ++n6;
        }
        if (n5 >= this.makeSwitchThreshold) {
            object3 = this.lookaheadString(1);
            bl2 = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if (_t==null) _t=ASTNULL;");
            }
            this.println("switch ( " + (String)object3 + ") {");
            n2 = 0;
            while (n2 < alternativeBlock.alternatives.size()) {
                object2 = alternativeBlock.getAlternativeAt(n2);
                if (((Alternative)object2).lookaheadDepth == 1 && ((Alternative)object2).semPred == null && !((Alternative)object2).cache[1].containsEpsilon()) {
                    object = ((Alternative)object2).cache[1];
                    if (((Lookahead)object).fset.degree() == 0 && !((Lookahead)object).containsEpsilon()) {
                        Tool.warning("Alternate omitted due to empty prediction set", ((Alternative)object2).head.getLine());
                    } else {
                        this.genCases(((Lookahead)object).fset);
                        this.println("{");
                        ++this.tabs;
                        this.genAlt((Alternative)object2, alternativeBlock);
                        this.println("break;");
                        --this.tabs;
                        this.println("}");
                    }
                }
                ++n2;
            }
            this.println("default:");
            ++this.tabs;
        }
        n2 = n = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0;
        while (n2 >= 0) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("checking depth " + n2);
            }
            int n7 = 0;
            while (n7 < alternativeBlock.alternatives.size()) {
                block41: {
                    String string;
                    boolean bl6;
                    block44: {
                        block42: {
                            int n8;
                            block43: {
                                block40: {
                                    object = alternativeBlock.getAlternativeAt(n7);
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("genAlt: " + n7);
                                    }
                                    if (!bl2 || ((Alternative)object).lookaheadDepth != 1 || ((Alternative)object).semPred != null || ((Alternative)object).cache[1].containsEpsilon()) break block40;
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("ignoring alt because it was in the switch");
                                    }
                                    break block41;
                                }
                                bl6 = false;
                                if (!(this.grammar instanceof LexerGrammar)) break block42;
                                n8 = ((Alternative)object).lookaheadDepth;
                                if (n8 == Integer.MAX_VALUE) {
                                    n8 = this.grammar.maxk;
                                }
                                while (n8 >= 1 && ((Alternative)object).cache[n8].containsEpsilon()) {
                                    --n8;
                                }
                                if (n8 == n2) break block43;
                                if (this.DEBUG_CODE_GENERATOR) {
                                    System.out.println("ignoring alt because effectiveDepth!=altDepth;" + n8 + "!=" + n2);
                                }
                                break block41;
                            }
                            bl6 = this.lookaheadIsEmpty((Alternative)object, n8);
                            string = this.getLookaheadTestExpression((Alternative)object, n8);
                            break block44;
                        }
                        bl6 = this.lookaheadIsEmpty((Alternative)object, this.grammar.maxk);
                        string = this.getLookaheadTestExpression((Alternative)object, this.grammar.maxk);
                    }
                    if (bl6 && ((Alternative)object).semPred == null && ((Alternative)object).synPred == null) {
                        if (n3 == 0) {
                            this.println("{");
                        } else {
                            this.println("else {");
                        }
                        javaBlockFinishingInfo.needAnErrorClause = false;
                    } else {
                        if (((Alternative)object).semPred != null) {
                            string = (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar) && this.grammar.debuggingOutput ? "(" + string + "&& fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING," + this.addSemPred(this.charFormatter.escapeString(((Alternative)object).semPred)) + "," + ((Alternative)object).semPred + "))" : "(" + string + "&&(" + ((Alternative)object).semPred + "))";
                        }
                        if (n3 > 0) {
                            if (((Alternative)object).synPred != null) {
                                this.println("else {");
                                ++this.tabs;
                                this.genSynPred(((Alternative)object).synPred, string);
                                ++n4;
                            } else {
                                this.println("else if " + string + " {");
                            }
                        } else if (((Alternative)object).synPred != null) {
                            this.genSynPred(((Alternative)object).synPred, string);
                        } else {
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println("if (_t==null) _t=ASTNULL;");
                            }
                            this.println("if " + string + " {");
                        }
                    }
                    ++n3;
                    ++this.tabs;
                    this.genAlt((Alternative)object, alternativeBlock);
                    --this.tabs;
                    this.println("}");
                }
                ++n7;
            }
            --n2;
        }
        object2 = "";
        int n9 = 1;
        while (n9 <= n4) {
            object2 = String.valueOf(object2) + "}";
            ++n9;
        }
        this.genAST = bl3;
        this.saveText = bl4;
        if (bl2) {
            --this.tabs;
            javaBlockFinishingInfo.postscript = String.valueOf(object2) + "}";
            javaBlockFinishingInfo.generatedSwitch = true;
            javaBlockFinishingInfo.generatedAnIf = n3 > 0;
        } else {
            javaBlockFinishingInfo.postscript = object2;
            javaBlockFinishingInfo.generatedSwitch = false;
            javaBlockFinishingInfo.generatedAnIf = n3 > 0;
        }
        return javaBlockFinishingInfo;
    }

    private void genElementAST(AlternativeElement alternativeElement) {
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            String string;
            String string2;
            boolean bl;
            boolean bl2 = bl = this.grammar.hasSyntacticPredicate && (alternativeElement.getLabel() != null || alternativeElement.getAutoGenType() != 3);
            if (alternativeElement.getLabel() != null) {
                string2 = alternativeElement.getLabel();
                string = String.valueOf(alternativeElement.getLabel()) + "_AST";
            } else {
                string2 = this.lt1Value;
                string = "tmp" + this.astVarNumber + "_AST";
                ++this.astVarNumber;
                this.println(String.valueOf(this.labeledElementASTType) + " " + string + " = null;");
                this.mapTreeVariable(alternativeElement, string);
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(String.valueOf(this.labeledElementASTType) + " " + string + "_in = null;");
                }
            }
            if (bl) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            if (alternativeElement.getLabel() != null) {
                this.println(String.valueOf(string) + " = " + this.getASTCreateString(string2) + ";");
            } else {
                string2 = this.lt1Value;
                this.println(String.valueOf(string) + " = " + this.getASTCreateString(string2) + ";");
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(String.valueOf(string) + "_in = " + string2 + ";");
                }
            }
            if (this.genAST) {
                switch (alternativeElement.getAutoGenType()) {
                    case 1: {
                        this.println("astFactory.addASTChild(currentAST, " + string + ");");
                        break;
                    }
                    case 2: {
                        this.println("astFactory.makeASTRoot(currentAST, " + string + ");");
                        break;
                    }
                }
            }
            if (bl) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = CodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(exceptionSpec);
        }
    }

    private void genErrorHandler(ExceptionSpec exceptionSpec) {
        int n = 0;
        while (n < exceptionSpec.handlers.size()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)exceptionSpec.handlers.elementAt(n);
            this.println("catch (" + exceptionHandler.exceptionTypeAndName.getText() + ") {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            this.printAction(this.processActionForTreeSpecifiers(exceptionHandler.action, 0, this.currentRule, null));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw " + this.extractIdOfAction(exceptionHandler.exceptionTypeAndName) + ";");
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
            ++n;
        }
    }

    private void genErrorTryForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = CodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    protected void genHeader() {
        this.println("/*");
        this.println(" * ANTLR-generated file resulting from grammar " + this.tool.grammarFile);
        this.println(" * ");
        this.println(" * Terence Parr, MageLang Institute");
        this.println(" * with John Lilley, Empathy Software");
        this.println(" * ANTLR Version 2.4.0; 1996,1997");
        this.println(" */");
    }

    private void genLiteralsTest() {
        this.println("_ttype = testLiteralsTable(_ttype);");
    }

    protected void genMatch(BitSet bitSet) {
    }

    protected void genMatch(GrammarAtom grammarAtom) {
        if (grammarAtom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
                return;
            }
            this.genMatchUsingAtomTokenType(grammarAtom);
            return;
        }
        if (grammarAtom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
                return;
            }
            this.tool.error("cannot ref character literals in grammar: " + grammarAtom);
            return;
        }
        if (grammarAtom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(grammarAtom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom grammarAtom) {
        String string = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            string = "_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || grammarAtom.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.print(grammarAtom.not ? "matchNot(" : "match(");
        this._print(string);
        if (grammarAtom.atomText.equals("EOF")) {
            this._print("Token.EOF_TYPE");
        } else {
            this._print(grammarAtom.atomText);
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || grammarAtom.getAutoGenType() == 3)) {
            this.println("text.setLength(_saveIndex);");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom grammarAtom) {
        String string = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            string = "_t,";
        }
        String string2 = String.valueOf(string) + this.getValueString(grammarAtom.tokenType);
        this.println(String.valueOf(grammarAtom.not ? "matchNot(" : "match(") + string2 + ");");
    }

    public void genNextToken() {
        Object object;
        Object object2;
        boolean bl = false;
        int n = 0;
        while (n < this.grammar.rules.size()) {
            object2 = (RuleSymbol)this.grammar.rules.elementAt(n);
            if (((RuleSymbol)object2).isDefined() && ((RuleSymbol)object2).access.equals("public")) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.println("");
            this.println("public Token nextToken() throws IOException { return new CommonToken(Token.EOF_TYPE, \"\"); }");
            this.println("");
            return;
        }
        object2 = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol ruleSymbol = new RuleSymbol("mnextToken");
        ruleSymbol.setDefined();
        ruleSymbol.setBlock((RuleBlock)object2);
        ruleSymbol.access = "private";
        this.grammar.define(ruleSymbol);
        this.grammar.theLLkAnalyzer.deterministic((AlternativeBlock)object2);
        this.println("");
        this.println("public Token nextToken() throws IOException {");
        ++this.tabs;
        this.println("Token _rettoken=null;");
        this.println("for (;;) {");
        ++this.tabs;
        this.println("Token _token = null;");
        this.println("int _ttype = Token.INVALID_TYPE;");
        this.println("resetText();");
        this.println("try {   // for error handling");
        ++this.tabs;
        int n2 = 0;
        while (n2 < ((AlternativeBlock)object2).getAlternatives().size()) {
            object = ((AlternativeBlock)object2).getAlternativeAt(n2);
            if (((Alternative)object).cache[1].containsEpsilon()) {
                Tool.warning("found optional path in nextToken()");
            }
            ++n2;
        }
        object = this.genCommonBlock((AlternativeBlock)object2, false);
        this.genBlockFinish((JavaBlockFinishingInfo)object, "if (LA(1)!=EOF_CHAR) " + this.throwNoViable + "_returnToken = makeToken(Token.EOF_TYPE);");
        this.println("_ttype = _returnToken.getType();");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("if ( _ttype!=Token.SKIP ) {");
        ++this.tabs;
        this.println("_returnToken.setType(_ttype);");
        this.println("return _returnToken;");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("catch (ScannerException e) {");
        ++this.tabs;
        this.println("consume();");
        this.println("reportError(e);");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("");
    }

    public void genRule(RuleSymbol ruleSymbol, boolean bl, int n) {
        String string;
        Object object;
        RuleBlock ruleBlock;
        this.tabs = 1;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRule(" + ruleSymbol.getId() + ")");
        }
        if (!ruleSymbol.isDefined()) {
            this.tool.error("undefined rule: " + ruleSymbol.getId());
            return;
        }
        this.currentRule = ruleBlock = ruleSymbol.getBlock();
        this.currentASTResult = ruleSymbol.getId();
        boolean bl2 = this.genAST;
        this.genAST = this.genAST && ruleBlock.getAutoGen();
        this.saveText = ruleBlock.getAutoGen();
        if (ruleSymbol.comment != null) {
            this._println(ruleSymbol.comment);
        }
        this.print(String.valueOf(ruleSymbol.access) + " final ");
        if (ruleBlock.returnAction != null) {
            this._print(String.valueOf(this.extractTypeOfAction(ruleBlock.returnAction, ruleBlock.getLine())) + " ");
        } else {
            this._print("void ");
        }
        this._print(String.valueOf(ruleSymbol.getId()) + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && ruleBlock.argAction != null) {
            this._print(",");
        }
        if (ruleBlock.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(ruleBlock.argAction);
            --this.tabs;
            this.print(")");
        } else {
            this._print(")");
        }
        this._print(" throws " + this.exceptionThrown);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            this._print(", IOException");
        }
        this._println(" {");
        ++this.tabs;
        if (ruleBlock.returnAction != null) {
            this.println(String.valueOf(ruleBlock.returnAction) + ";");
        }
        this.println(this.commonLocalVars);
        if (this.grammar.traceRules) {
            this.println("traceIn(\"" + ruleSymbol.getId() + "\",_t);");
        }
        if (this.grammar instanceof LexerGrammar) {
            if (ruleSymbol.getId().equals("mEOF")) {
                this.println("_ttype = Token.EOF_TYPE;");
            } else {
                this.println("_ttype = " + ruleSymbol.getId().substring(1) + ";");
            }
            this.println("int _saveIndex;");
        }
        if (this.grammar.debuggingOutput) {
            if (this.grammar instanceof ParserGrammar) {
                this.println("fireEnterRule(" + n + ",0);");
            } else if (this.grammar instanceof LexerGrammar) {
                this.println("fireEnterRule(" + n + ",_ttype);");
            }
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            this.println("try { // debugging");
            ++this.tabs;
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = null;");
            this.println("ASTPair currentAST = new ASTPair();");
            this.println(String.valueOf(this.labeledElementASTType) + " " + ruleSymbol.getId() + "_AST = null;");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println(String.valueOf(this.labeledElementASTType) + " " + ruleSymbol.getId() + "_AST_in = (" + this.labeledElementASTType + ")_t;");
            }
        }
        this.genBlockPreamble(ruleBlock);
        this.println("");
        ExceptionSpec exceptionSpec = ruleBlock.findExceptionSpec("");
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        if (ruleBlock.alternatives.size() == 1) {
            object = ruleBlock.getAlternativeAt(0);
            string = ((Alternative)object).semPred;
            if (string != null) {
                this.genSemPred(string);
            }
            if (((Alternative)object).synPred != null) {
                Tool.warning("Syntactic predicate ignored for single alternative", ((Alternative)object).synPred.getLine());
            }
            this.genAlt((Alternative)object, ruleBlock);
        } else {
            this.grammar.theLLkAnalyzer.deterministic(ruleBlock);
            object = this.genCommonBlock(ruleBlock, false);
            this.genBlockFinish((JavaBlockFinishingInfo)object, this.throwNoViable);
        }
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            --this.tabs;
            this.println("}");
        }
        if (exceptionSpec != null) {
            this.genErrorHandler(exceptionSpec);
        } else if (ruleBlock.getDefaultErrorHandler()) {
            this.println("catch (" + this.exceptionThrown + " ex) {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (guessing==0) {");
                ++this.tabs;
            }
            this.println("reportError(ex);");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                object = this.grammar.theLLkAnalyzer.FOLLOW(1, ruleBlock.endNode);
                string = this.getBitsetName(this.markBitsetForGen(((Lookahead)object).fset));
                this.println("consume();");
                this.println("consumeUntil(" + string + ");");
            } else {
                this.println("if (_t!=null) {_t = _t.getNextSibling();}");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                this.println("  throw ex;");
                this.println("}");
            }
            --this.tabs;
            this.println("}");
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = " + ruleSymbol.getId() + "_AST;");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_retTree = _t;");
        }
        if (ruleBlock.getTestLiterals()) {
            this.genLiteralsTest();
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( _createToken && _token==null ) {");
            this.println("\t_token = makeToken(_ttype);");
            this.println("\t_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));");
            this.println("}");
            this.println("_returnToken = _token;");
        }
        if (ruleBlock.returnAction != null) {
            this.println("return " + this.extractIdOfAction(ruleBlock.returnAction, ruleBlock.getLine()) + ";");
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            --this.tabs;
            this.println("} finally { // debugging");
            ++this.tabs;
            if (this.grammar.debuggingOutput) {
                if (this.grammar instanceof ParserGrammar) {
                    this.println("fireExitRule(" + n + ",0);");
                } else if (this.grammar instanceof LexerGrammar) {
                    this.println("fireExitRule(" + n + ",_ttype);");
                }
            }
            if (this.grammar.traceRules) {
                this.println("traceOut(\"" + ruleSymbol.getId() + "\",_t);");
            }
            --this.tabs;
            this.println("}");
        }
        --this.tabs;
        this.println("}");
        this.println("");
        this.genAST = bl2;
    }

    private void GenRuleInvocation(RuleRefElement ruleRefElement) {
        this._print(String.valueOf(ruleRefElement.targetRule) + "(");
        if (this.grammar instanceof LexerGrammar) {
            if (ruleRefElement.getLabel() != null) {
                this._print("true");
            } else {
                this._print("false");
            }
            if (this.commonExtraArgs.length() != 0 || ruleRefElement.args != null) {
                this._print(",");
            }
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && ruleRefElement.args != null) {
            this._print(",");
        }
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule);
        if (ruleRefElement.args != null) {
            ActionTransInfo actionTransInfo = new ActionTransInfo();
            String string = this.processActionForTreeSpecifiers(ruleRefElement.args, 0, this.currentRule, actionTransInfo);
            if (actionTransInfo.assignToRoot || actionTransInfo.refRuleRoot != null) {
                this.tool.error("Arguments of rule reference '" + ruleRefElement.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName() + " on line " + ruleRefElement.getLine());
            }
            this._print(string);
            if (ruleSymbol.block.argAction == null) {
                Tool.warning("Rule '" + ruleRefElement.targetRule + "' accepts no arguments", ruleRefElement.getLine());
            }
        }
        this._println(");");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _retTree;");
        }
    }

    protected void genSemPred(String string) {
        String string2 = this.charFormatter.escapeString(string);
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            string = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + this.addSemPred(string2) + "," + string + ")";
        }
        this.println("if (!(" + string + "))");
        this.println("  throw new SemanticException(\"" + string2 + "\");");
    }

    protected void genSemPredMap() {
        Enumeration enumeration = this.semPreds.elements();
        this.println("private String _semPredNames[] = {");
        while (enumeration.hasMoreElements()) {
            this.println("\"" + enumeration.nextElement() + "\",");
        }
        this.println("};");
    }

    protected void genSynPred(SynPredBlock synPredBlock, String string) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + synPredBlock + ")");
        }
        this.println("boolean synPredMatched" + synPredBlock.ID + " = false;");
        this.println("if (" + string + ") {");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("AST __t" + synPredBlock.ID + " = _t;");
        } else {
            this.println("int _m" + synPredBlock.ID + " = mark();");
        }
        this.println("synPredMatched" + synPredBlock.ID + " = true;");
        this.println("guessing++;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("fireSyntacticPredicateStarted();");
        }
        ++this.syntacticPredLevel;
        this.println("try {");
        ++this.tabs;
        this.gen(synPredBlock);
        --this.tabs;
        this.println("}");
        this.println("catch (" + this.exceptionThrown + " pe) {");
        ++this.tabs;
        this.println("synPredMatched" + synPredBlock.ID + " = false;");
        --this.tabs;
        this.println("}");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = __t" + synPredBlock.ID + ";");
        } else {
            this.println("rewind(_m" + synPredBlock.ID + ");");
        }
        this.println("guessing--;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof ParserGrammar)) {
            this.println("if (synPredMatched" + synPredBlock.ID + ")");
            this.println("  fireSyntacticPredicateSucceeded();");
            this.println("else");
            this.println("  fireSyntacticPredicateFailed();");
        }
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("}");
        this.println("if ( synPredMatched" + synPredBlock.ID + " ) {");
    }

    public void genTokenStrings() {
        this.println("");
        this.println("public static final String[] _tokenNames = {");
        ++this.tabs;
        Vector vector = this.grammar.tokenManager.getVocabulary();
        int n = 0;
        while (n < vector.size()) {
            TokenSymbol tokenSymbol;
            String string = (String)vector.elementAt(n);
            if (string == null) {
                string = "<" + String.valueOf(n) + ">";
            }
            if (!string.startsWith("\"") && !string.startsWith("<") && (tokenSymbol = this.grammar.tokenManager.getTokenSymbol(string)) != null && tokenSymbol.getParaphrase() != null) {
                string = Tool.stripFrontBack(tokenSymbol.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(string));
            if (n != vector.size() - 1) {
                this._print(",");
            }
            this._println("");
            ++n;
        }
        --this.tabs;
        this.println("};");
    }

    protected void genTokenTypes(TokenManager tokenManager) throws IOException {
        this.setupOutput(String.valueOf(tokenManager.getName()) + "TokenTypes");
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.headerAction);
        this.println("public interface " + tokenManager.getName() + "TokenTypes {");
        ++this.tabs;
        Vector vector = tokenManager.getVocabulary();
        this.println("public static final int EOF = " + 1 + ";");
        this.println("public static final int NULL_TREE_LOOKAHEAD = " + 3 + ";");
        int n = 4;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                if (string.startsWith("\"")) {
                    StringLiteralSymbol stringLiteralSymbol = (StringLiteralSymbol)this.grammar.tokenManager.getTokenSymbol(string);
                    if (stringLiteralSymbol == null) {
                        Tool.panic("String literal " + string + " not in symbol table");
                    } else if (stringLiteralSymbol.label != null) {
                        this.println("public static final int " + stringLiteralSymbol.label + " = " + n + ";");
                    } else {
                        String string2 = this.mangleLiteral(string);
                        if (string2 != null) {
                            this.println("public static final int " + string2 + " = " + n + ";");
                            stringLiteralSymbol.label = string2;
                        } else {
                            this.println("// " + string + " = " + n);
                        }
                    }
                } else if (!string.startsWith("<")) {
                    this.println("public static final int " + string + " = " + n + ";");
                }
            }
            ++n;
        }
        --this.tabs;
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    public String getASTCreateString(Vector vector) {
        if (vector.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(" + this.labeledElementASTType + ")astFactory.make( (new ASTArray(" + vector.size() + "))");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(".add(" + vector.elementAt(n) + ")");
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getASTCreateString(String string) {
        return "(" + this.labeledElementASTType + ")astFactory.create(" + string + ")";
    }

    protected String getLookaheadTestExpression(Alternative alternative, int n) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        if (n == 0) {
            return "true";
        }
        boolean bl = true;
        int n3 = 1;
        while (n3 <= n2 && n3 <= n) {
            BitSet bitSet = alternative.cache[n3].fset;
            if (!bl) {
                stringBuffer.append(") && (");
            }
            bl = false;
            if (alternative.cache[n3].containsEpsilon()) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append(this.getLookaheadTestTerm(n3, bitSet));
            }
            ++n3;
        }
        stringBuffer.append(")");
        return "(" + stringBuffer.toString() + ")";
    }

    protected String getLookaheadTestTerm(int n, BitSet bitSet) {
        String string = this.lookaheadString(n);
        int[] nArray = bitSet.toArray();
        if (CodeGenerator.elementsAreRange(nArray)) {
            return this.getRangeExpression(n, nArray);
        }
        if (bitSet.degree() >= this.bitsetTestThreshold) {
            int n2 = this.markBitsetForGen(bitSet);
            return String.valueOf(this.getBitsetName(n2)) + ".member(" + string + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < nArray.length) {
            String string2 = this.getValueString(nArray[n3]);
            if (n3 > 0) {
                stringBuffer.append("||");
            }
            stringBuffer.append(string);
            stringBuffer.append("==");
            stringBuffer.append(string2);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String getRangeExpression(int n, int[] nArray) {
        if (!CodeGenerator.elementsAreRange(nArray)) {
            Tool.panic("getRangeExpression called with non-range");
        }
        int n2 = nArray[0];
        int n3 = nArray[nArray.length - 1];
        return "(" + this.lookaheadString(n) + " >= " + this.getValueString(n2) + " && " + this.lookaheadString(n) + " <= " + this.getValueString(n3) + ")";
    }

    private String getValueString(int n) {
        String string;
        if (this.grammar instanceof LexerGrammar) {
            string = this.charFormatter.literalChar(n);
        } else {
            String string2 = this.grammar.tokenManager.getTokenStringAt(n);
            if (string2 == null) {
                Tool.panic("vocabulary for token type " + n + " is null");
            }
            if (string2.startsWith("\"")) {
                string = this.mangleLiteral(string2);
                if (string == null) {
                    string = String.valueOf(n);
                }
            } else {
                string = string2;
            }
        }
        return string;
    }

    protected boolean lookaheadIsEmpty(Alternative alternative, int n) {
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        int n3 = 1;
        while (n3 <= n2 && n3 <= n) {
            BitSet bitSet = alternative.cache[n3].fset;
            if (bitSet.degree() != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private String lookaheadString(int n) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "_t.getType()";
        }
        return "LA(" + n + ")";
    }

    private String mangleLiteral(String string) {
        String string2 = Tool.literalsPrefix;
        int n = 1;
        while (n < string.length() - 1) {
            if (!Character.isLetter(string.charAt(n)) && string.charAt(n) != '_') {
                return null;
            }
            string2 = String.valueOf(string2) + string.charAt(n);
            ++n;
        }
        if (Tool.upperCaseMangledLiterals) {
            string2 = string2.toUpperCase();
        }
        return string2;
    }

    public String mapTreeId(String string, ActionTransInfo actionTransInfo) {
        Object object;
        if (this.currentRule == null) {
            return string;
        }
        boolean bl = false;
        String string2 = string;
        if (this.grammar instanceof TreeWalkerGrammar && string2.length() > 3 && string2.lastIndexOf("_in") == string2.length() - 3) {
            string2 = string2.substring(0, string2.length() - 3);
            bl = true;
        }
        int n = 0;
        while (n < this.currentRule.labeledElements.size()) {
            object = (AlternativeElement)this.currentRule.labeledElements.elementAt(n);
            if (((AlternativeElement)object).getLabel().equals(string2)) {
                if (bl) {
                    return string2;
                }
                return String.valueOf(string2) + "_AST";
            }
            ++n;
        }
        object = (String)this.treeVariableMap.get(string2);
        if (object != null) {
            if (object == NONUNIQUE) {
                return null;
            }
            if (((String)object).equals(this.currentRule.getRuleName())) {
                return null;
            }
            if (bl) {
                return String.valueOf(object) + "_in";
            }
            return object;
        }
        if (string2.equals(this.currentRule.getRuleName())) {
            String string3;
            String string4 = string3 = bl ? String.valueOf(string2) + "_AST_in" : String.valueOf(string2) + "_AST";
            if (actionTransInfo != null && !bl) {
                actionTransInfo.refRuleRoot = string3;
            }
            return string3;
        }
        return string2;
    }

    private void mapTreeVariable(AlternativeElement alternativeElement, String string) {
        if (alternativeElement instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)alternativeElement).root, string);
            return;
        }
        String string2 = null;
        if (alternativeElement.getLabel() == null) {
            if (alternativeElement instanceof TokenRefElement) {
                string2 = ((TokenRefElement)alternativeElement).atomText;
            } else if (alternativeElement instanceof RuleRefElement) {
                string2 = ((RuleRefElement)alternativeElement).targetRule;
            }
        }
        if (string2 != null) {
            if (this.treeVariableMap.get(string2) != null) {
                this.treeVariableMap.remove(string2);
                this.treeVariableMap.put(string2, NONUNIQUE);
                return;
            }
            this.treeVariableMap.put(string2, string);
        }
    }

    private void setupGrammarParameters(Grammar grammar) {
        if (grammar instanceof ParserGrammar) {
            String string;
            Token token;
            this.labeledElementASTType = "AST";
            if (grammar.hasOption("ASTLabelType") && (token = grammar.getOption("ASTLabelType")) != null && (string = Tool.stripFrontBack(token.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = string;
            }
            this.labeledElementType = "Token ";
            this.labeledElementInit = "null";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = "ParserException";
            this.throwNoViable = "throw new NoViableAltException(LT(1));";
            return;
        }
        if (grammar instanceof LexerGrammar) {
            this.labeledElementType = "char ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "boolean _createToken";
            this.commonLocalVars = "int _ttype; Token _token=null; int _begin=text.length();";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = "ScannerException";
            this.throwNoViable = "throw new ScannerException(\"no viable alt for char: \"+(char)LA(1),getLine());";
            return;
        }
        if (grammar instanceof TreeWalkerGrammar) {
            String string;
            Token token;
            this.labeledElementASTType = "AST";
            this.labeledElementType = "AST";
            if (grammar.hasOption("ASTLabelType") && (token = grammar.getOption("ASTLabelType")) != null && (string = Tool.stripFrontBack(token.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = string;
                this.labeledElementType = string;
            }
            if (!grammar.hasOption("ASTLabelType")) {
                grammar.setOption("ASTLabelType", new Token(17, "AST"));
            }
            this.labeledElementInit = "null";
            this.commonExtraArgs = "_t";
            this.commonExtraParams = "AST _t";
            this.commonLocalVars = "";
            this.lt1Value = "(" + this.labeledElementASTType + ")_t";
            this.exceptionThrown = "ParserException";
            this.throwNoViable = "throw new NoViableAltException(_t);";
            return;
        }
        Tool.panic("Unknown grammar type");
    }

    public void setupOutput(String string) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(string) + ".java");
    }
}

