/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.ClassList;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.omegahat.Environment.Tools.ClassList.ArchiveClassList;
import org.omegahat.Environment.Tools.ClassList.ClassList;
import org.omegahat.Environment.Tools.ClassList.ClassLocatorInt;
import org.omegahat.Environment.Tools.ClassList.PackageClassList;
import org.omegahat.Environment.Tools.ClassList.SubArchiveClassList;
import org.omegahat.Environment.Tools.ClassList.URLClassList;
import org.omegahat.Environment.Utils.OrderedTable;

public class ClassLocator
extends OrderedTable
implements ClassLocatorInt,
Serializable {
    public ClassLocator() {
        super(1);
    }

    public ClassLocator(File file) {
        super(1);
        this.add(file);
    }

    public ClassLocator(URL uRL) {
        super(1);
        this.add(uRL);
    }

    public ClassLocator(Vector vector2) {
        this.append(vector2);
    }

    public ClassLocator(ClassList classList) {
        super(1);
        this.add(classList);
    }

    public ClassLocator(String[] stringArray) {
        this();
        this.append(stringArray);
    }

    public Object add(File file) {
        ClassList classList = this.classList(file);
        this.put(file, classList);
        return classList;
    }

    public Object add(Object object) {
        Object object2 = null;
        if (object instanceof String) {
            object2 = this.add((String)object);
        } else if (object instanceof File) {
            object2 = this.add((File)object);
        } else if (object instanceof URL) {
            this.add((URL)object);
        } else if (object instanceof ClassList) {
            this.add((ClassList)object);
        } else {
            new Exception("Don't recognize class list " + object.getClass() + " " + object);
        }
        return object2;
    }

    public Object add(String string) {
        Object object = null;
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            object = this.add(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            object = this.add(new File(string));
        }
        return object;
    }

    public Object add(URL uRL) {
        ClassList classList = this.classList(uRL);
        this.put(uRL, classList);
        return classList;
    }

    public Object add(ClassList classList) {
        this.put(classList, classList);
        return classList;
    }

    public Object add(File[] fileArray) {
        Object[] objectArray = new Object[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            objectArray[n] = this.add(fileArray[n]);
            ++n;
        }
        return objectArray;
    }

    public Object add(String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            objectArray[n] = this.add(stringArray[n]);
            ++n;
        }
        return objectArray;
    }

    public Object add(URL[] uRLArray) {
        Object[] objectArray = new Object[uRLArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            objectArray[n] = this.add(uRLArray[n]);
            ++n;
        }
        return objectArray;
    }

    public int append(Vector vector2) {
        if (vector2 == null) {
            return -1;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
        return vector2.size();
    }

    public int append(String[] stringArray) {
        if (stringArray == null) {
            return -1;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n]);
            ++n;
        }
        return stringArray.length;
    }

    public boolean canReadSerializedLists(File file) {
        String string = System.getProperty("readSerializedClassLists");
        if (string != null) {
            return new Boolean(string);
        }
        return true;
    }

    public ClassList classList(File file) {
        return this.classList(file, null);
    }

    public ClassList classList(File file, String string) {
        Object object;
        ClassList classList = null;
        if (this.canReadSerializedLists(file) && (object = this.getClass().getResourceAsStream(this.serializedName(file))) != null) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                classList = (ClassList)objectInputStream.readObject();
                return classList;
            }
            catch (Exception exception) {}
        }
        try {
            object = new ZipFile(file);
            classList = string != null ? new SubArchiveClassList(file, string) : new ArchiveClassList(file);
            return classList;
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        if (file.toString().endsWith(String.valueOf(System.getProperty("file.separator", "/").charAt(0)) + "..")) {
            if (string == null) {
                object = file.toString();
                object = ((String)object).substring(0, ((String)object).length() - 3);
                int n = ((String)object).lastIndexOf(System.getProperty("file.separator", "/").charAt(0));
                object = ((String)object).substring(n, ((String)object).length());
            } else {
                object = string;
            }
            try {
                classList = new PackageClassList(file.getCanonicalPath(), (String)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            classList = new ClassList(file);
        }
        return classList;
    }

    public ClassList classList(URL uRL) {
        return this.classList(uRL, null);
    }

    public ClassList classList(URL uRL, String string) {
        URLClassList uRLClassList = new URLClassList(uRL);
        return uRLClassList;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        string = string.replace('.', '/');
        ClassList classList = null;
        Class clazz = null;
        Enumeration enumeration = this.ordered().elements();
        while (enumeration.hasMoreElements()) {
            classList = (ClassList)enumeration.nextElement();
            clazz = classList.findClass(string);
            if (clazz != null) break;
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public Vector findClasses(String string, Vector vector2) {
        string = string.replace('.', '/');
        ClassList classList = null;
        Class clazz = null;
        Enumeration enumeration = this.ordered().elements();
        while (enumeration.hasMoreElements()) {
            classList = (ClassList)enumeration.nextElement();
            clazz = classList.findClass(string);
            if (clazz == null || vector2.contains(clazz)) continue;
            vector2.add(clazz);
        }
        return vector2;
    }

    public String serializedName(File file) {
        return String.valueOf(file.getName()) + ".ser";
    }
}

