% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence_criteria.R
\name{MC_error}
\alias{MC_error}
\alias{plot.MCElist}
\title{Monte Carlo error}
\usage{
MC_error(x, subset = NULL, start = NULL, end = NULL, thin = NULL,
  digits = 2, warn = TRUE, mess = TRUE, ...)

\method{plot}{MCElist}(x, data_scale = TRUE, plotpars = NULL,
  ablinepars = list(v = 0.05), ...)
}
\arguments{
\item{x}{object inheriting from class 'JointAI'}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC sample).
Uses the same logic as the argument \code{monitor_params} in
\code{\link{lm_imp}}, \code{\link{glm_imp}}, \code{\link{clm_imp}},
\code{\link{lme_imp}}, \code{\link{glme_imp}}, \code{\link{survreg_imp}}
and \code{\link{coxph_imp}}.}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{digits}{number of digits for output}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}. Note: this applies only to warnings
given directly by \strong{JointAI}.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}. Note: this applies only to messages
given directly by \strong{JointAI}.}

\item{...}{Arguments passed on to \code{mcmcse::mcse.mat}
\describe{
  \item{size}{the batch size. The default value is
  \dQuote{\code{sqroot}}, which uses the square root of the
  sample size. \dQuote{\code{cuberoot}} will cause the
  function to use the cube root of the sample size. A
  numeric value may be provided if neither
  \dQuote{\code{sqroot}} nor \dQuote{\code{cuberoot}} is
  satisfactory.}
  \item{g}{a function such that \eqn{E(g(x))} is the
  quantity of interest. The default is \code{NULL}, which
  causes the identity function to be used.}
  \item{method}{the method used to compute the standard
  error. This is one of \dQuote{\code{bm}} (batch means,
  the default), \dQuote{\code{obm}} (overlapping batch
  means), \dQuote{\code{tukey}} (spectral variance method
  with a Tukey-Hanning window), or \dQuote{\code{bartlett}}
  (spectral variance method with a Bartlett window).}
}}

\item{data_scale}{show the Monte Carlo error of the sample transformed back
to the scale of the data (\code{TRUE}) or on the sampling scale (this
requires the argument \code{keep_scaled_mcmc = TRUE} in the JointAI model)}

\item{plotpars}{optional; list of parameters passed to \code{\link[graphics]{plot}()}}

\item{ablinepars}{optional; list of parameters passed to \code{\link[graphics]{abline}()}}
}
\value{
An object of class \code{MCElist} with elements \code{unscaled},
        \code{scaled} and \code{digits}. The first two are matrices with
        columns \code{est} (posterior mean), \code{MCSE} (Monte Carlo error),
        \code{SD} (posterior standard deviation) and \code{MCSE/SD}
        (Monte Carlo error divided by post. standard deviation.)
}
\description{
Calculate and plot the Monte Carlo error of the samples from a JointAI model.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: plot Monte Carlo error
}}

\note{
Lesaffre & Lawson (2012) [p. 195] suggest the Monte Carlo error of a
      parameter should not be more than 5\% of the posterior standard
      deviation of this parameter (i.e., \eqn{MCSE/SD \le 0.05}).
}
\examples{
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)

MC_error(mod)

plot(MC_error(mod), ablinepars = list(lty = 2))

}
\references{
Lesaffre, E., & Lawson, A. B. (2012).
\emph{Bayesian Biostatistics}.
John Wiley & Sons.
}
\seealso{
The vignette \href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
contains some examples how to specify the argument \code{subset}.
}
