library(JointNets)

graphics.off()
par(ask = FALSE)
par(mfrow = c(1, 1))


readline(prompt = "Press [enter] to continue to cancer demo with 2 tasks (not v. pcr) and 26 features (26 cancer types) ")

data(cancer)
cancerlist = list(as.matrix(cancer[[1]][which(cancer[[2]] == "not"), ]),
                  as.matrix(cancer[[1]][which(cancer[[2]] == "pcr"), ]))

p = dim(cancerlist[[1]])[2]
result = kdiffnet(cancerlist[[1]], cancerlist[[2]], W = matrix(1,p,p), g=rep(0,p),lambda = 0.2,covType = "kendall")
label = colnames(cancer[[1]])
graph = returngraph(result)
layout = layout_nicely(graph, dim = 2)

readline(prompt = "Press [enter] to view the difference graph generated by diffee")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  nodeid = which(label %in% c("BECNI", "FLJI2650"))
  plot(result,
       type = "neighbour",
       index = nodeid,
       layout = layout)
}

readline(prompt = "Press [enter] to continue to NIPS conference word count demo with 2 tasks (before 2006 and after 2006) and 37 features (37 words)")


data(nip_37_data)
label = colnames(nip_37_data[[1]])

p = dim(nip_37_data[[1]])[2]
result = kdiffnet(nip_37_data[[1]], nip_37_data[[2]], W = matrix(1,p,p), g=rep(0,p),lambda = 0.1,covType = "kendall")
graph = returngraph(result)
layout = layout_nicely(graph, dim = 2)

readline(prompt = "Press [enter] to view the difference graph")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  nodeid = which(label %in% c("results", "section")) ### look for id
  plot(result,
       type = "neighbour",
       index = nodeid,
       layout = layout)
}



readline(prompt = "Press [enter] to continue to synthetic Gaussian data demo with 2 tasks and 20 features")


data(exampleData)
p = dim(exampleData[[1]])[2]
result = kdiffnet(exampleData[[1]], exampleData[[2]], W = matrix(1,p,p), g=rep(0,p),lambda = 0.105,covType = "kendall")
data(exampleDataGraph)
layout = layout_nicely(exampleDataGraph[[1]], dim = 2)


readline(prompt = "Press [enter] to view comparison between ground truth and generated difference graph")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  plot(
    union(exampleDataGraph[[2]], exampleDataGraph[[3]]),
    layout = layout,
    vertex.label.font = 2,
    vertex.shape = "none",
    vertex.label.color = "gray40",
    vertex.label.cex = .7,
    vertex.frame.color = "white",
    vertex.size = 10 ,
    edge.color = rainbow(1)[1],
    main = "difference graph ground truth"
  )

}

