% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/returngraph.R
\name{returngraph}
\alias{returngraph}
\title{return igraph object from jointnet result specified by user input}
\usage{
returngraph(x, ...)
}
\arguments{
\item{x}{output generated from any one of the jointnet functions}

\item{...}{additional arguments, see \code{\link{returngraph.simule}}, \code{\link{returngraph.wsimule}},
\code{\link{returngraph.diffee}}, \code{\link{returngraph.jeek}} for details.}
}
\value{
an igraph object of graph / subgraph from jointnet result specified by user input
}
\description{
This function returns an igraph object from jointnet result for user to work with directly
}
\details{
the function aims to provide users the flexibility to explore and visualize the graph on their own
generated from jointnet
}
\examples{
library(JointNets)
data(exampleData)
result = jeek(X = exampleData, 0.3, covType = "cov", parallel = FALSE)
graph = returngraph(result)
}
\author{
Beilun Wang, Zhaoyang Wang (Author), Zhaoyang Wang (maintainer) \email{zw4dn@virginia.edu}
}
