% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_results.R
\name{read_results}
\alias{read_results}
\title{Reads track and field results into a list of strings in preparation for parsing with \code{tf_parse}}
\usage{
read_results(file, node = "pre")
}
\arguments{
\item{file}{a .pdf or .html file (could be a url) where containing swimming track and field results.  pdfs with multiple columns will not work.}

\item{node}{a CSS node where html results are stored.  Required for html results.  Default is "pre", which nearly always works.}
}
\value{
returns a list of strings containing the information from \code{file}.  Should then be parsed with \code{tf_parse}
}
\description{
Outputs list of strings to be processed by \code{tf_parse}
}
\examples{
\donttest{read_results("https://www.flashresults.com/2018_Meets/Outdoor/05-05_A10/015-1.pdf")}

}
\seealso{
\code{read_results} is meant to be followed by \code{\link{tf_parse}}
}
\author{
Greg Pilgrim \email{gpilgrim2670@gmail.com}
}
