% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KHQConvKHQ5D.R
\name{KHQConvKHQ5D}
\alias{KHQConvKHQ5D}
\title{KHQConvKHQ5D}
\usage{
KHQConvKHQ5D(
  scores,
  save.xlsx = FALSE,
  filename = NULL,
  sheetName = NULL,
  ignore.invalid = FALSE
)
}
\arguments{
\item{scores}{data.frame containing 9 items that compose the KHQ5D; colnames
must be 3a, 3b, 4a, 4b, 4d, 5c, 6a, 6b, and 7a.}

\item{save.xlsx}{logical to indicate whether or not save the results; Default: FALSE.}

\item{filename}{string specifying the file name if save.xlsx = TRUE;
Default: "KHQ_conv_KHQ5D.xlsx".}

\item{sheetName}{string specifying the sheet name if save.xlsx = TRUE;
Default: "Scores".}

\item{ignore.invalid}{logical to indicate whether to ignore items data
with invalid, incomplete or missing data; Default: FALSE}
}
\value{
A data frame with scores of the KHQ five dimensions (KHQ5D).
}
\description{
Function used to convert the KHQ item scores to KHQ5D scores.
}
\details{
Nine items of the KHQ are used to calculate the KHQ5D scores. The
items must be named equal the number in the original questionnaire (3a, 3b,
4a, 4b, 4d, 5c, 6a, 6b, 7a).
}
\examples{
scores.df <- data.frame(
  "3a" = c(4,3,4,3,2), "3b" = c(4,3,4,3,2), 
  "4a" = c(1,3,4,3,4), "4b" = c(1,3,4,3,4), 
  "4d" = c(2,2,3,4,2), "5c" = c(2,2,3,4,2), 
  "6a" = c(3,2,2,4,1), "6b" = c(3,2,2,4,1),
  "7a" = c(1,3,4,3,4), check.names = FALSE)

KHQConvKHQ5D(scores = scores.df, ignore.invalid = FALSE)

scores.df2 <- data.frame(
  "3a" = c(4,3,4,3,2), "3b" = c(4,3,4,3,2), 
  "4a" = c(1,3,4,3,4), "4b" = c(1,3,4,3,4), 
  "4d" = c(2,2,3,4,2), "5c" = c(2,2,3,4,2), 
  "6a" = c(3,2,2,4,1), "6b" = c(3,2,2,4,1),
  "7a" = c(1,3,4,3,4), check.names = FALSE)

KHQConvKHQ5D(scores = scores.df2, save.xlsx = FALSE,
  filename = "KHQ_conv_KHQ5D.xlsx", sheetName = "Scores",
  ignore.invalid = TRUE)

KHQConvKHQ5D(scores = KHQ_Conv_KHQ5D_data, save.xlsx = FALSE,
  filename = "KHQ_conv_KHQ5D.xlsx", sheetName = "Scores",
  ignore.invalid = TRUE)

}
\seealso{
\code{\link[KHQ]{KHQ5D}}
}
