% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairsimu.R
\name{pairsimu}
\alias{pairsimu}
\title{Pairwise simulation}
\usage{
pairsimu(af, ss, delta, allelename = FALSE)
}
\arguments{
\item{af}{name of allele frequency matrix, a data.frame of 1 column containing frequencies with allele names being row names, which can be loaded with "EvaluatePanel" function, not necessary if Parent is not NULL}

\item{ss}{sample size, i.e., how many individual pairs do you want simulate}

\item{delta}{distribution of IBD or Jacquard coefficient of specific relationship, i.e., kappa(0-2) or Delta(1-9), respectively. Which should be input in form of single row of data with c() function. It should be noted that the data should be in order of kappa0 to kappa2 or Delta1 to Delta9.}

\item{allelename}{if TRUE, outputing the names of alleles, otherwise, the positions of them in the af matrix}
}
\value{
A data.frame with four columns and \code{ss} rows, consisting of the alleles of the first individual in the first two columns and the alleles of the second individual in the remaining two columns.
}
\description{
Generating genotype combinations of multiple individual pairs with specific relationships on an autosomal marker, ignoring mutaion
}
\examples{
# Take the first STR in the 42 STR as example
af = FortytwoSTR$afmatrix[[1]]
# simulating 10,000 unrelated pairs
a<-pairsimu(af = af,ss = 10000,delta = c(1,0,0),allelename = FALSE)
# simulating 10,000 parent-child pairs
b<-pairsimu(af = af,ss = 10000,delta = c(0,1,0),allelename = FALSE)
# simulating 10,000 full-sibling pairs
c<-pairsimu(af = af,ss = 10000,delta = c(0.25,0.5,0.25),allelename = FALSE)

}
