% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MFKM.R
\name{MFKM}
\alias{MFKM}
\title{KM for Quantitative Traits in Multivariate Family GWAS Data (calculate p-value)}
\usage{
MFKM(obj, genotypes, weights = NULL, acc = 1e-04, append.write = NULL,
  eq.gen.effect = F)
}
\arguments{
\item{obj}{results saved from MFKM_Null_Model.}

\item{genotypes}{1st column: gene name; 2nd column: snp name; 3rd-end columns: A matrix of genotypes for each subject (class: data.frame). The order of 3rd-end columns should match unique(yid). Coded as 0, 1, 2 and no missing. This genotype file can be a big file containing all genes or it can be files containing one single gene.}

\item{weights}{1st column: gene name; 2nd column: snp name; 3rd column: A vector with the length equal to the number of variants in the test (class: data.frame). Default is Null indicating equal weight for all markers.}

\item{acc}{Accuracy of numerical integration used in Davies' method. Default 1e-4.}

\item{append.write}{The name of pvalue output file. Write out p-values in real time. Don't need to wait until all genes are processed to get the final output.}

\item{eq.gen.effect}{Whether assume equal genetic effects on different traits (default = False).}
}
\value{
output: multivariate family KM (MF-KM) p-value
}
\description{
This function (MFKM) is used to perform KM analysis (Yan et al., 2015) for quantitative traits in GWAS multivariate family data.
}
\examples{
########################################################################################
### Examples for Multivariate (two) Continuous Traits in Familial GWAS Data using KM ###
########################################################################################
### Subject IDs are numeric ###
data("MFKM_numID")
obj1 <- MFKM_Null_Model(phenotype=mfkm_n_y$y, trait=mfkm_n_y$trait, yid=mfkm_n_y$id,
gid=mfkm_n_geneid$gid, fa=mfkm_n_geneid$fa, mo=mfkm_n_geneid$mo, covariates=NULL,
Ninitial=3)
#One should try multiple initial values in order to find max log-likelihood. The default
#is 10 times. In this illustrative case, it is 3 times.
#This could be time consuming, depends on the sample size. The good thing is that null
#model only needs to be fitted once for the whole genome, so it's worth trying many
#initial values. The initial value with max logl can be saved in ./LogLikelihood.txt
#for reuse.
pvalue1 <- MFKM(obj=obj1, genotypes=mfkm_n_gene, weights=NULL, append.write=
"./pvalues.out")
#If one wants to replicate the results, finds the initial value "cor" with the max
#loglikelihood in ./LogLikelihood.txt that is output by default. The 1st column is
#"cor"; 2nd column is "log-likelihood".
obj1 <- MFKM_Null_Model(phenotype=mfkm_n_y$y, trait=mfkm_n_y$trait, yid=mfkm_n_y$id,
gid=mfkm_n_geneid$gid, fa=mfkm_n_geneid$fa, mo=mfkm_n_geneid$mo, covariates=NULL,
cor=0.687439771651474)
pvalue1 <- MFKM(obj=obj1, genotypes=mfkm_n_gene, weights=NULL)
#If Ninitial=1, the initial value "cor" is always equal to
#correlation(trait1|covariates, trait2|covariates).
obj1 <- MFKM_Null_Model(phenotype=mfkm_n_y$y, trait=mfkm_n_y$trait, yid=mfkm_n_y$id,
gid=mfkm_n_geneid$gid, fa=mfkm_n_geneid$fa, mo=mfkm_n_geneid$mo, covariates=NULL,
Ninitial=1)
pvalue1 <- MFKM(obj=obj1, genotypes=mfkm_n_gene, weights=NULL)
#Read in a list of genes files instead of a big file containing all genes
obj <- MFKM_Null_Model(phenotype=mfkm_n_y$y, trait=mfkm_n_y$trait, yid=mfkm_n_y$id,
gid=mfkm_n_geneid$gid, fa=mfkm_n_geneid$fa, mo=mfkm_n_geneid$mo, covariates=NULL,
Ninitial=1)
gene <- split(mfkm_n_gene, mfkm_n_gene[,1])
for (k in 1:2) {
  gene[[k]]$gene <- as.character(gene[[k]]$gene)
  pvalue1 <- MFKM(obj=obj, genotypes=gene[[k]], weights=NULL, append.write=
  "./pvalues.out")
}
### Subject IDs are character ###
data("MFKM_charID")
obj1 <- MFKM_Null_Model(phenotype=mfkm_c_y$y, trait=mfkm_c_y$trait,
yid=as.character(mfkm_c_y$id),
gid=as.character(mfkm_c_geneid$gid), fa=as.character(mfkm_c_geneid$fa),
mo=as.character(mfkm_c_geneid$mo), covariates=NULL, Ninitial=1)
pvalue1 <- MFKM(obj=obj1, genotypes=mfkm_c_gene, weights=NULL)
}

