% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nobsKspm.R
\name{nobs.kspm}
\alias{nobs.kspm}
\title{Extract the number of observations from a Kernel Semi parametric Model Fit}
\usage{
\method{nobs}{kspm}(object, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{...}{additional optional argument (currently unused).}
}
\value{
A single number (integer).
}
\description{
Extract the number of observations use to estimate the model coefficients. This is principally intented to be used in computing BIC (see \link{extractAIC.kspm}).
}
\examples{
x <- 1:15
y <- 3*x + rnorm(15, 0, 2)
fit <- kspm(y, kernel = ~ Kernel(x, kernel.function = "linear"))
nobs(fit)

}
\seealso{
\link{kspm} for fitting model, \link{extractAIC.kspm}.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
