% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.L0Learn}
\alias{coef.L0Learn}
\alias{coef.L0LearnCV}
\title{Extract Solutions}
\usage{
\method{coef}{L0Learn}(object, lambda, gamma = 0, ...)

\method{coef}{L0LearnCV}(object, lambda, gamma = 0, ...)
}
\arguments{
\item{object}{The output of L0Learn.fit or L0Learn.cvfit}

\item{lambda}{The value(s) of lambda at which to extract the solution.}

\item{gamma}{The value of gamma at which to extract the solution. Note that, unlike lambda, this can only take single values.}

\item{...}{ignore}
}
\description{
Extracts a specific solution in the regularization path
}
\examples{
# Generate synthetic data for this example
data <- GenSynthetic(n=500,p=1000,k=10,seed=1)
X = data$X
y = data$y

# Fit an L0L2 Model with 10 values of Gamma ranging from 0.0001 to 10, using coordinate descent
fit <- L0Learn.fit(X, y, penalty="L0L2", maxSuppSize=50, nGamma=10, gammaMin=0.0001, gammaMax = 10)
print(fit)
# Extract the coefficients of the solution at lambda = 0.0361829 and gamma = 0.0001
coef(fit, lambda=0.0361829, gamma=0.0001)

}
