% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LA_OofA.R
\name{LA_OofA}
\alias{LA_OofA}
\title{Lioness Algorithm for order-of-addition design}
\usage{
LA_OofA(
  n = factorial(k),
  k,
  m = 10,
  N = 10,
  prun = 1/(n - 1),
  OC = "D",
  maxtime = 5
)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size). The default setting of \code{n} is \code{k} factorial, which yields a full order-of-addition design matrix. Note that the maximum of \code{n} cannot be greater than \code{k} factorial.}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}

\item{m}{A positive integer, which stands for the number of starting lionesses agents. The default is set to be 10, and it is recommended to be no greater than 100.}

\item{N}{A positive integer, which stands for the number of iterations. The default is set to be 10. A large value of \code{N} will result a high CPU time, and it is recommended to be no greater than 500.}

\item{prun}{A probability, which stands for the probability of "prey runs away", and it is denoted as \code{p*} in the original paper. The default is set to be 1/(\code{n} - 1).}

\item{OC}{An optimality criterion. The default setting is "D", which stands for the D-optimality criterion, and in the future we would add other criteria such as A-optimality criterion and E-optimality criterion.}

\item{maxtime}{A positive number, which indicates the expected maximum CPU time given by user, and it is measured by minutes. For example, maxtime=3.5 indicates the CPU time will be no greater than three and half minutes. The default is set to be 5.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} order-of-addition design.
}
\description{
\code{LA_OofA} returns a \code{n} by \code{k} order-of-addition design matrix generated by lioness algorithm (LA)
}
\examples{
#generate a D-optimal full OofA with 4 factors.
try=LA_OofA(k=4)
try
det(MOM(try))  #the determinant of the moment matrix of try

#Another example
#generate a D-optimal 11-run OofA with 4 factors.
try2=LA_OofA(n=11,k=4)
try2
det(MOM(try2)) #the determinant of the moment matrix of try2
}
