% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDVI2LAI.R
\name{NDVI2LAI}
\alias{NDVI2LAI}
\title{Derive LAI from NDVI using a set of conversion functions}
\usage{
NDVI2LAI(input,
 ID=NULL,
 biome=NULL,
 category=NULL,
 type=NULL,
 name=NULL,
 sensor=NULL,
 platform=NULL,
 resolution=NULL)
}
\arguments{
\item{input}{Raster* or numeric vector. For multi-layer Raster images, the computation is performed for each layer.}

\item{ID}{Character. Optional parameter to select the function based on its code. For available options, type 'NDVI2LAIeq' (field 'F.ID')}

\item{biome}{Numeric. Optional integer representing the Biome, sensu Olson and Dinerstein 1998 \doi{10.1046/j.1523-1739.1998.012003502.x}. For available options, type 'NDVI2LAIeq' (field 'Location.Biome.Code' and 'Location.Biome').}

\item{category}{Character. Optional parameter to select the Plant Category among: "Crop" "Forest" "Mixed".}

\item{type}{Character. Optional parameter to select the Plant Type. For available options, type 'NDVI2LAIeq' (field 'Plant.Type')}

\item{name}{Character. Optional parameter to select the Plant Name. For available options, type 'NDVI2LAIeq' (field 'Plant.Name')}

\item{sensor}{Character. Optional parameter to select the Sensor Name. For available options, type 'NDVI2LAIeq' (field 'Sensor.Name')}

\item{platform}{Character. Optional parameter to select the Sensor Platform among: "Satellite" "Field" "Airborne".}

\item{resolution}{Character. Optional parameter to select the Sensor Resolution Class. For available options, type 'NDVI2LAIeq' (field 'Sensor.ResolutionClass')}
}
\value{
A Raster* or a dataframe depending on the input.
}
\description{
The function calculates LAI from NDVI values given as a raster or a numeric vector input.
The conversion uses the formulas compiled by  Bajocco et al. 2022 \doi{10.3390/rs14153554}.
The choice of the equation depends on arguments related to vegetation (category, type, name), or sensor (name, platform, resolution).
If no filtering arguments are provided, the function calculate all 199 equations.
The function returns a Raster* or a dataframe depending on the input, with the LAI values computed from the available selected conversion equations.
}
\examples{
# generate a raster
set.seed(123)
input <- terra::rast(ncol = 9, nrows = 9, vals = runif(81))
res <- NDVI2LAI(input, category = 'Crop', name = c('Vineyard', 'Barley'), sensor = 'MODIS')
terra::plot(res)

#using a vector
NDVI2LAI(seq(0.5,1,.2), category = 'Mixed', sensor = c('PROBA-V', 'SPOT'))

}
\seealso{
Bajocco et al. (2022). On the Use of NDVI to Estimate LAI in Field Crops: Implementing a Conversion Equation Library. Remote Sens. , 3554, doi: \doi{10.3390/rs14153554}\cr
}
