% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lascouting.R
\name{lascouting}
\alias{lascouting}
\title{Find the liquid association scouting genes.}
\usage{
lascouting(network.graph, express.matrix, k = 2, n.cores = 4)
}
\arguments{
\item{network.graph}{An igraph object representing the gene network.}

\item{express.matrix}{A matrix representing the expression matrix for the genes in gene
network. Row names are the gene ids in gene network.}

\item{k}{Integer giving the order of the ego-network.}

\item{n.cores}{Number of cores used for parallel computing.}
}
\value{
A logical matrix representing the LA-scouting genes for each gene. Rows represent
the ego gene id and columns represents the LA-scouting genes.
}
\description{
\code{lascouting()} is used to find the liquid association scouting gene
}
\examples{
\dontrun{laresult <- lascouting(g,m,k=2,n.cores=4)}
}

