% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDM_fun.R
\name{adjust.data.by.covariates}
\alias{adjust.data.by.covariates}
\title{Adjusting data (distance matrix and OTU table) by covariates}
\usage{
adjust.data.by.covariates(
  formula = NULL,
  data = .GlobalEnv,
  otu.table = NULL,
  tree = NULL,
  dist.method = "bray",
  binary = FALSE,
  dist = NULL,
  square.dist = TRUE,
  center.dist = TRUE,
  scale.otu.table = TRUE,
  center.otu.table = TRUE,
  freq.scale.only = FALSE
)
}
\arguments{
\item{formula}{a symbolic description of the covariate model in the form \code{ ~ model}, 
where \code{model} is specified in the same way as for \code{lm} or \code{glm}. For example, 
\code{~ a + b} specifies a model with the main effects of covariates \code{a} and \code{b}, and 
\code{~ a*b}, equivalently \code{~ a + b + a:b}, specifies a model with the main effects of 
\code{a} and \code{b} as well as their interaction.}

\item{data}{an optional data frame, list or environment (or object coercible 
by as.data.frame to a data frame) containing the covariates. 
If not found in \code{data}, the covariates are taken from environment (formula), 
typically the environment from which \code{adjust.data.by.covariates} is called. 
The default is .GlobalEnv.}

\item{otu.table}{the \code{n.obs} by \code{n.otu} matrix of read counts. 
If provided, an adjusted (and column-centered) OTU table at the frequency (i.e., relative abundance) scale 
and an adjusted (and columnn-centered) OTU table at the arcsin-root-transformed frequency scale are output. If provided, 
it is also used for calculating the distance matrix unless the distance matrix is directly 
imported through \code{dist}.
The default is NULL.}

\item{tree}{a phylogenetic tree. Only used for calculating a
phylogenetic-tree-based distance matrix. Not needed if the calculation of
requested distance does not require a phylogenetic tree, or if the distance
matrix is directly imported through \code{dist}. The default is NULL.}

\item{dist.method}{method for calculating the distance measure, partial
match to all methods supported by \code{vegdist} in the \code{vegan} package
 (i.e., "manhattan", "euclidean", "canberra", "bray", "kulczynski", "jaccard", "gower", 
 "altGower", "morisita", "horn", "mountford", "raup" , "binomial", "chao", "cao", "mahalanobis")
  as well as "hellinger" and "wt-unifrac". 
  The default is "bray". 
  For more details, see the \code{dist.method} argument in the \code{ldm} function.}

\item{binary}{the "binary" parameter in \code{vegdist}. The default is FALSE.}

\item{dist}{a distance matrix. Can be either an object of class "dist" or "matrix".
The elements of the distance matrix will be squared and then the matrix will be centered if the default choices 
\code{square.dist=TRUE} and \code{center.dist=TRUE} are used. If \code{dist=NULL}, the distance matrix is 
calculated from the \code{otu.table}, using the value of \code{dist.method} (and \code{tree} if required). 
The default is NULL.}

\item{square.dist}{a logical variable indicating whether to square the 
distance matrix. The default is TRUE.}

\item{center.dist}{a logical variable indicating whether to center the 
distance matrix as described by Gower (1966). The default is TRUE.}

\item{scale.otu.table}{a logical variable indicating whether to scale the rows of the OTU table 
for the frequency scale.  For count data, this corresponds to dividing by the library size to give 
relative frequencies. The default is TRUE.}

\item{center.otu.table}{a logical variable indicating whether to center the 
columns of the OTU table. The OTU table should be centered if the distance 
matrix has been centered. Applied to both OTU tables at frequency and transformed scales. The default is TRUE.}

\item{freq.scale.only}{a logical variable indicating whether to provide adjusted frequency-scale OTU table only 
(not adjusted OTU table at the arcsin-root transformed frequency scale). The default is FALSE.}
}
\value{
a list consisting of 
  \item{adj.dist}{the (squared/centered) distance matrix
  after adjustment of covariates.}
  \item{y.freq}{the (column-centered) frequency-scale OTU table after adjustment of covariates.} 
  \item{y.tran}{the (column-centered) arcsin-root-transformed 
  OTU table after adjustment of covariates.}
}
\description{
This function produces adjusted distance matrix and OTU table (if provided) 
after removing the effects of covariates (e.g., confounders). 
Observations with any missing data are removed.
}
\examples{
adj.data <- adjust.data.by.covariates(formula= ~ Sex + AntibioticUse, data=throat.meta,
                                      otu.table=throat.otu.tab5, dist.method="bray")
}
\author{
Yi-Juan Hu <yijuan.hu@emory.edu>, Glen A. Satten <gsatten@emory.edu>
}
\keyword{PCA}
\keyword{distance}
\keyword{microbiome}
\keyword{ordination}
