% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastMmLHD.R
\name{FastMmLHD}
\alias{FastMmLHD}
\title{Fast Maximin Distance LHD}
\usage{
FastMmLHD(n, k, method = "manhattan", t1 = 10)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size).}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}

\item{method}{A distance measure method. The default setting is "manhattan", and it could be one of the following: "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski". Any unambiguous substring can be given.}

\item{t1}{A tunning parameter, which determines how many repeats will be implemented to search for the optimal design. The default is set to be 10.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} maximin distance LHD under under the maximin L_1 distance criterion..
}
\description{
\code{FastMmLHD} returns a \code{n} by \code{k} maximin distance LHD matrix generated by the construction method of Wang, L., Xiao, Q., and Xu, H. (2018)
}
\examples{
#n by n design when 2n+1 is prime
try=FastMmLHD(8,8)
try
phi_p(try)   #calculate the phi_p of "try".

#n by n design when n+1 is prime
try2=FastMmLHD(12,12)
try2
phi_p(try2)   #calculate the phi_p of "try2".

#n by n-1 design when n is prime
try3=FastMmLHD(7,6)
try3
phi_p(try3)   #calculate the phi_p of "try3".

#General cases
try4=FastMmLHD(24,8)
try4
phi_p(try4)   #calculate the phi_p of "try4".

}
\references{
Wang, L., Xiao, Q., and Xu, H. (2018)  Optimal maximin $L_{1}$-distance Latin hypercube designs based on good lattice point designs. \emph{The Annals of Statistics}, \strong{46}(6B), 3741-3766.
}
