% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_weather_agent.R
\name{parse_and_validate_location}
\alias{parse_and_validate_location}
\title{Clean and Validate a Location Query}
\usage{
parse_and_validate_location(query)
}
\arguments{
\item{query}{Character. A free-text user request (e.g. `"weather in Paris"`).}
}
\value{
A cleaned location string, suitable for passing to the
        OpenWeatherMap API (e.g. `"Paris, FR"`).  Raises an error if
        the cleaned location is too short or contains digits.
}
\description{
Performs basic text cleaning on a free-form weather/location query,
strips out common words like "weather", "forecast", "in", "for", and "please",
then enforces minimal length and alphabetic-only constraints.
If no country code is present, it also suggests the user include one.
}
\examples{
parse_and_validate_location("weather in New York")
\dontrun{
parse_and_validate_location("12345")  # error
}

}
