% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.ltrccf,}
\alias{print.ltrcrrf}
\title{Print Summary Output of a ltrccf object or a ltrcrrf object}
\usage{
print(x)
}
\arguments{
\item{x}{an object of class \code{ltrccf} or \code{ltrcrrf}.}
}
\description{
Print summary output after a LTRCCF or a LTRCRRF model is built.
This is the default print method for objects in the class of \code{\link{ltrccf}} or 
\code{\link{ltrcrrf}}.
}
\examples{

library(survival)
Formula = Surv(Start, Stop, Event) ~ age + alk.phos + ast + chol + edema
# Built a LTRCCF forest on the time-varying data by specifying id, with mtry specified:
LTRCCFobj = ltrccf(formula = Formula, data = pbcsample, id = ID, mtry = 3, ntree = 50L)
print(LTRCCFobj)

# Built a LTRCCF forest on the time-invariant data, with resampling, with mtry specified:
LTRCCFobj = ltrccf(formula = Formula, data = pbcsample, samptype = "swr",
                   mtry = 3, ntree = 50L)
print(LTRCCFobj)
}
\seealso{
\code{\link{ltrccf}}, \code{\link{ltrcrrf}}
}
