% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLWauto.R
\name{fitLWauto}
\alias{fitLWauto}
\title{Best Fit Using Litchfield and Wilcoxon Evaluation of Dose-Effect Experiments}
\usage{
fitLWauto(DEdata)
}
\arguments{
\item{DEdata}{A data frame of dose-effect data (typically, the output from
\code{\link{dataprep}}) containing at least eight variables:
dose, ntot, nfx, pfx, log10dose, bitpfx, fxcateg, and LWkeep
(see Details).}
}
\value{
A numeric vector of length two, the estimated intercept and slope of the
  dose-response curve on the log10-probit scale,
}
\description{
Use optimization to describe the best fitting line to a dose-effect experiment
following the methods of Litchfield and Wilcoxon (1949).
}
\details{
The input data are expected to be summarized by dose.
  If duplicate doses are provided, an error will be thrown.
}
\examples{
dose <- c(0.0625, 0.125, 0.25, 0.5, 1)
ntested <- rep(8, 5)
nalive <- c(1, 4, 4, 7, 8)
mydat <- dataprep(dose=dose, ntot=ntested, nfx=nalive)
mydat
fitLWauto(mydat)
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
    A simplified method of evaluating dose-effect experiments.
    Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
    \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}
