% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viterbi_p.R
\name{viterbi_p}
\alias{viterbi_p}
\title{Viterbi algorithm for decoding states of periodically inhomogeneous HMMs}
\usage{
viterbi_p(delta, Gamma, allprobs, tod)
}
\arguments{
\item{delta}{Initial or periodically statioanary distribution of length N}

\item{Gamma}{Array of transition probability matrices of dimension c(N,N,L), where L is the cycle length.}

\item{allprobs}{Matrix of state-dependent probabilities/ density values of dimension c(n, N)}

\item{tod}{Integer valued cyclic variable to index the transition probability matrix.}
}
\value{
Vector of decoded states of length n
}
\description{
Viterbi algorithm for decoding states of periodically inhomogeneous HMMs
}
\examples{
delta = c(0.5, 0.5)
beta = matrix(c(-2, 1, -1,
                -2, -1, 1), nrow = 2, byrow = TRUE)
Gamma = tpm_p(1:24, 24, beta)

tod = rep(1:24, 10)
n = length(tod)

allprobs = matrix(runif(2*n), nrow = n, ncol = 2)
states = viterbi_p(delta, Gamma, allprobs, tod)
}
