% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary_functions.R
\name{stationary_cont}
\alias{stationary_cont}
\title{Compute the stationary distribution of a continuous-time Markov chain}
\usage{
stationary_cont(Q)
}
\arguments{
\item{Q}{infinitesimal generator matrix of dimension c(N,N)}
}
\value{
stationary distribution of the continuous-time Markov chain with given generator matrix
}
\description{
A well-behaved continuous-time Markov chain converges to a unique stationary distribution, here called \eqn{\pi}.
This distribution satisfies
\deqn{\pi Q = 0,} subject to \eqn{\sum_{j=1}^N \pi_j = 1},
where \eqn{Q} is the infinitesimal generator of the Markov chain.
This function solves the linear system of equations above for a given generator matrix.
}
\examples{
Q = generator(c(-2,-2))
Pi = stationary_cont(Q)
}
\seealso{
\code{\link{generator}} to create a generator matrix

Other stationary distribution functions: 
\code{\link{stationary}()},
\code{\link{stationary_p}()}
}
\concept{stationary distribution functions}
