% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimum.R
\name{minimum}
\alias{minimum}
\title{Minimum between factors}
\usage{
minimum(x, y, concatenate.names = TRUE)
}
\arguments{
\item{x}{vector that will be interpreted as a factor.}

\item{y}{vector that will be interpreted as a factor.}

\item{concatenate.names}{boolean. If \code{TRUE} then the levels of the minimum are constructed as the concatenation of the levels for \code{x} and \code{y}. If \code{FALSE} then the levels of the minimum are given as numbers. Defaults to \code{TRUE}.}
}
\value{
A factor with the minimum.
}
\description{
\code{minimum} finds the minimum of two factors, i.e. the finest factors that is coarser than both of the factors.
}
\examples{
x <- rep(c("boy","girl","adult","adult"),4)
y <- rep(c("child","child","man","woman"),4)
minimum(x,y)
minimum(x,y,FALSE)

}
\author{
Bo Markussen
}
\keyword{manip}
