% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_U-utils.R, R/dU.R, R/pU.R, R/qU.R, R/rU.R
\name{U-utils}
\alias{U-utils}
\alias{dU}
\alias{pU}
\alias{qU}
\alias{rU}
\title{Zero-mean, unit-variance version of standard distributions}
\usage{
dU(u, beta, distname, use.mean.variance = TRUE)

pU(u, beta, distname, use.mean.variance = TRUE)

qU(p, beta, distname, use.mean.variance = TRUE)

rU(n, beta, distname, use.mean.variance = TRUE)
}
\arguments{
\item{u}{vector of quantiles.}

\item{beta}{numeric vector (deprecated); parameter \eqn{\boldsymbol \beta} of
the input distribution.  See \code{\link{check_beta}} on how to specify
\code{beta} for each distribution.}

\item{distname}{character; name of input distribution; see
\code{\link{get_distnames}}.}

\item{use.mean.variance}{logical; if \code{TRUE} it uses mean and variance
implied by \eqn{\boldsymbol \beta} to do the transformation (Goerg 2011).
If \code{FALSE}, it uses the alternative definition from Goerg (2016)
with location and scale parameter.}

\item{p}{vector of probability levels}

\item{n}{number of samples}
}
\value{
\code{dU} evaluates the pdf at \code{y}, \code{pU} evaluates the
cdf, \code{qU} is the quantile function, and \code{rU} generates random
samples from U.
}
\description{
Density, distribution function, quantile function and random number
    generation for the shifted and scaled U of the
    (location-)scale family input \eqn{X \sim F_X(x \mid \boldsymbol \beta)}
    - see References.

Since the normalized random variable U is one of the main building blocks of
    Lambert W \eqn{\times} F distributions, these functions are wrappers used
    by other functions such as \code{\link{dLambertW}} or
    \code{\link{rLambertW}}.
}
\examples{

# a zero-mean, unit variance version of the t_3 distribution.
curve(dU(x, beta = c(1, 1, 3), distname = "t"), -4, 4,
      ylab = "pdf", xlab = "u",
      main = "student-t \\n zero-mean, unit variance")
# cdf of unit-variance version of an exp(3) -> just an exp(1)
curve(pU(x, beta = 3, distname = "exp"), 0, 4, ylab = "cdf", xlab = "u",
      main = "Exponential \\n unit variance", col = 2, lwd = 2) 
curve(pexp(x, rate = 1), 0, 4, add = TRUE, lty = 2)
# all have (empirical) variance 1
var(rU(n = 1000, distname = "chisq", beta = 2))
var(rU(n = 1000, distname = "normal", beta = c(3, 3)))
var(rU(n = 1000, distname = "exp", beta = 1))
var(rU(n = 1000, distname = "unif", beta = c(0, 10)))

}
\keyword{datagen}
\keyword{distribution}
\keyword{univar}

