% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LagLaplaceDeconvolution.R
\name{LaguerreLaplaceConvolution}
\alias{LaguerreLaplaceConvolution}
\title{function LaguerreLaplaceConvolution}
\usage{
LaguerreLaplaceConvolution(t, g, f.coef, a)
}
\arguments{
\item{t,}{numeric vector, the observation times}

\item{g,}{numeric vector, the observed values of the known Laplace convolution kernel at the observation times}

\item{f.coef,}{numeric vector, the coefficients in the Laguerre function basis of the function f to convole with g}

\item{a,}{numeric, the scale of the  Laguerre functions basis}
}
\value{
return the Laplace convolution of f and g using Trapezoidal formula and expansion of f in the Laguerre function basis
}
\description{
computes the Laplace convolution of two functions f and g observed at discrete times t. Use trapezoidal formula and an expansion of f in the Laguerre function basis.
}
\examples{
\dontrun{

 library(LaplaceDeconv)
 a = 1/2
 t = seq(0,10,l=100)
 g = exp(-5*t)
 f.coef = c(1,0.25,0.1)
 # compute the Laplace convolution from g, kernel computed at times t, and the function described by
 # its decomposition in Laguerre function basis with scale a
 fg = LaguerreLaplaceConvolution(t,g,f.coef,a)
 matplot(t,cbind(MakeLaguerreMatrix(a,3)(t)\%*\%f.coef,g,fg),lty=1,type='l',ylab='')
 legend('topright',lty=1,legend=c('f','g','fxg'),col=1:3)
 }
}
\author{
Y. Rozenholc and M. Pensky
}

