% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Homothety.R
\name{Homothety}
\alias{Homothety}
\title{Creates an homothety from a given polygon}
\usage{
Homothety(Poly, C, k, lines = F)
}
\arguments{
\item{Poly}{Polygon object, previously created with function \code{CreatePolygon}}

\item{C}{Vector containing the xy-coordinates of the center of the homothety}

\item{k}{Number which represents the expansion or contraction factor for the homothety}

\item{lines}{Boolean. When \code{lines} = \code{TRUE}, the plot displays the lines that connect the center of the homothety with the points of the polygons (the original and the transformed one). If missing, it works as with \code{lines} = \code{FALSE}, so the lines are not displayed}
}
\value{
Returns the coordinates of a polygon that has been transformed according to the homothethy with center at \code{C} and factor \code{k}
}
\description{
\code{Homothety} creates an homothety from a given polygon
}
\examples{
x_min <- -2
x_max <- 6
y_min <- -3
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Poly <- CreatePolygon(P1, P2, P3)
Draw(Poly, "blue")
C <- c(-1,-2)
k1 <- 0.5
Poly_homothety1 <- Homothety(Poly, C, k1, lines = TRUE)
Draw(Poly_homothety1, "orange")
k2 <- 2
Poly_homothety2 <- Homothety(Poly, C, k2, lines = TRUE)
Draw(Poly_homothety2, "orange")
}
\references{
https://www.encyclopediaofmath.org/index.php/Homothety
}
