% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShearedPolygon.R
\name{ShearedPolygon}
\alias{ShearedPolygon}
\title{Creates a sheared polygon from a given one}
\usage{
ShearedPolygon(Poly, k, direction)
}
\arguments{
\item{Poly}{Polygon object, previously created with function \code{CreatePolygon} or \code{CreateRegularPolygon}}

\item{k}{Number that represents the shear factor which is applied to the original polygon}

\item{direction}{String with value "horizontal" or "vertical" which indicates the direction in which shearing is applied. Horizontal means the shearing is parallel to the X axis, while vertical means parallel to the Y axis}
}
\value{
Returns a sheared polygon, in any of the two axis, to the original one
}
\description{
\code{ShearedPolygon} creates a sheared polygon from a given one
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
Square <- CreateRegularPolygon(4, c(-2, 0), 1)
Draw(Square, "blue")
k <- 1
Square_shearX <- Translate(ShearedPolygon(Square, k, "horizontal"), c(3,0))
Draw(Square_shearX, "orange")
Square_shearY <- Translate(ShearedPolygon(Square, k, "vertical"), c(3,0))
Draw(Square_shearY, "orange")
}
