% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.LiblineaR}
\alias{predict.LiblineaR}
\title{Predictions with LiblineaR model}
\usage{
\method{predict}{LiblineaR}(object, newx, proba = FALSE, decisionValues = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{"LiblineaR"}, created by
\code{LiblineaR}.}

\item{newx}{An n x p matrix containing the new input data. A vector will be
transformed to a n x 1 matrix. Sparse matrices of class matrix.csr from 
package SparseM or sparse matrices of class dgCMatrix or dgRMatrix from
package Matrix are also accepted. Note that C code at the core of LiblineaR
package corresponds to a row-based sparse format. Hence, dgCMatrix inputs
are first transformed into dgRMatrix format, which requires small extra
computation time.}

\item{proba}{Logical indicating whether class probabilities should be
computed and returned. Only possible if the model was fitted with
\code{type}=0, \code{type}=6 or \code{type}=7, i.e. a Logistic Regression.
Default is \code{FALSE}.}

\item{decisionValues}{Logical indicating whether model decision values should
be computed and returned. Only possible for classification models
(\code{type}<10). Default is \code{FALSE}.}

\item{...}{Currently not used}
}
\value{
By default, the returned value is a list with a single entry:
\item{predictions}{A vector of predicted labels (or values for regression).}
If \code{proba} is set to \code{TRUE}, and the model is a logistic
regression, an additional entry is returned:
\item{probabilities}{An n x k matrix (k number of classes) of the class
  probabilities. The columns of this matrix are named after class labels.}
If \code{decisionValues} is set to \code{TRUE}, and the model is not a
regression model, an additional entry is returned:
\item{decisionValues}{An n x k matrix (k number of classes) of the model
  decision values. The columns of this matrix are named after class labels.}
}
\description{
The function applies a model (classification or regression) produced by the \code{LiblineaR} function to every row of a
data matrix and returns the model predictions.
}
\note{
If the data on which the model has been fitted have been centered
  and/or scaled, it is very important to apply the same process on the
  \code{newx} data as well, with the scale and center values of the training
  data.
}
\references{
\itemize{
\item 
For more information on LIBLINEAR itself, refer to:\cr
R.-E. Fan, K.-W. Chang, C.-J. Hsieh, X.-R. Wang, and C.-J. Lin.\cr
\emph{LIBLINEAR: A Library for Large Linear Classification,}\cr
Journal of Machine Learning Research 9(2008), 1871-1874.\cr
\url{https://www.csie.ntu.edu.tw/~cjlin/liblinear/}
}
}
\seealso{
\code{\link{LiblineaR}}
}
\author{
Thibault Helleputte \email{thibault.helleputte@dnalytics.com} and\cr
  Jerome Paul \email{jerome.paul@dnalytics.com} and Pierre Gramme.\cr
  Based on C/C++-code by Chih-Chung Chang and Chih-Jen Lin
}
\keyword{classes}
\keyword{classif}
\keyword{models}
\keyword{multivariate}
\keyword{optimize}
\keyword{regression}
