% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{deathBenefit.annuityDecreasing}
\alias{deathBenefit.annuityDecreasing}
\title{Describes the death benefit of a decreasing whole life insurance (after a possible deferall period)}
\usage{
deathBenefit.annuityDecreasing(interest)
}
\arguments{
\item{interest}{The interest rate of the loan, which is underlying the insurance.}
}
\description{
The death benefit will be the full sumInsured for the first year after the
deferral period and then decrease like an annuity to 0 at the end of the policyPeriod.
This can be used with the \code{deathBenefit} parameter for insurance
contracts, but should not be called directly.
}
\details{
This function is a mere generator function, which takes the interest rate and
generates a function that describes a decreasing annuity.

The generated function has the following parameters:
\describe{
\item{len}{The desired length of the Cash flow vector (can be shorter than
the policyPeriod, if q_x=1 before the end of the contract, e.g.
for life-long insurances)}
\item{params}{The full parameter set of the insurance contract (including
all inherited values from the tariff and the profit participation)}
\item{values}{The values calculated from the insurance contract so far}
}
}
