% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexact.R
\name{lexact}
\alias{lexact}
\title{Generate rating-scale data with only Mean and Standard Deviation}
\usage{
lexact(n, mean, sd, lowerbound, upperbound, items = 1, seed)
}
\arguments{
\item{n}{(positive, int) the number of observations to simulate}

\item{mean}{(real)  target mean}

\item{sd}{(real)  target standard deviation}

\item{lowerbound}{(positive, int) a lower bound for the data to be generated}

\item{upperbound}{(positive, int) an upper bound for the data to be generated}

\item{items}{(positive, int) number of items in the Likert scale. Default = 1}

\item{seed}{(real)  optional seed for reproducibility}
}
\value{
a vector with user-specified parameters
}
\description{
\code{lexact()} generates rating-scale values with
predefined first and second moments.
}
\details{
If feasible, moments are exact to two decimal places.
}
\examples{

x <- lexact(
  n = 16,
  mean = 3.25,
  sd = 1.00,
  lowerbound = 1,
  upperbound = 5,
  items = 4
)

}
