% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlateScales.R
\name{correlateScales}
\alias{correlateScales}
\title{Create a dataframe of correlated scales from different dataframes of scale items}
\usage{
correlateScales(dataframes, scalecors)
}
\arguments{
\item{dataframes}{a list of 'k' dataframes to be rearranged and combined}

\item{scalecors}{target correlation matrix - should be a symmetric
k*k positive-semi-definite matrix, where 'k' is the number of dataframes}
}
\value{
Returns a dataframe whose columns are taken from the starter
dataframes and whose summated values are correlated according to a
user-specified correlation matrix
}
\description{
\code{correlateScales()} creates a dataframe of
scale items representing correlated constructs,
as one might find in a completed questionnaire.
}
\details{
Correlated rating-scale items generally are summed or
averaged to create a measure of an "unobservable", or "latent", construct.
\code{correlateScales()} takes several such dataframes of rating-scale
items and rearranges their rows so that the scales are correlated according
to a predefined correlation matrix. Univariate statistics for each dataframe
of rating-scale items do not change,
but their correlations with rating-scale items in other dataframes do.
}
\examples{

## three attitudes and a behavioural intention
n <- 32
lower <- 1
upper <- 5

### attitude #1
cor_1 <- makeCorrAlpha(items = 4, alpha = 0.90)
means_1 <- c(2.5, 2.5, 3.0, 3.5)
sds_1 <- c(0.9, 1.0, 0.9, 1.0)

Att_1 <- makeItems(
  n = n, means = means_1, sds = sds_1,
  lowerbound = rep(lower, 4), upperbound = rep(upper, 4),
  cormatrix = cor_1
)



### attitude #2
cor_2 <- makeCorrAlpha(items = 5, alpha = 0.85)
means_2 <- c(2.5, 2.5, 3.0, 3.0, 3.5)
sds_2 <- c(1.0, 1.0, 0.9, 1.0, 1.5)

Att_2 <- makeItems(
  n = n, means = means_2, sds = sds_2,
  lowerbound = rep(lower, 5), upperbound = rep(upper, 5),
  cormatrix = cor_2
)



### attitude #3
cor_3 <- makeCorrAlpha(items = 6, alpha = 0.75)
means_3 <- c(2.5, 2.5, 3.0, 3.0, 3.5, 3.5)
sds_3 <- c(1.0, 1.5, 1.0, 1.5, 1.0, 1.5)

Att_3 <- makeItems(
  n = n, means = means_3, sds = sds_3,
  lowerbound = rep(lower, 6), upperbound = rep(upper, 6),
  cormatrix = cor_3
)



### behavioural intention
intent <- lfast(n, mean = 3.0, sd = 3, lowerbound = 0, upperbound = 10) |>
  data.frame()
names(intent) <- "int"


### target scale correlation matrix
scale_cors <- matrix(
  c(
    1.0, 0.6, 0.5, 0.3,
    0.6, 1.0, 0.4, 0.2,
    0.5, 0.4, 1.0, 0.1,
    0.3, 0.2, 0.1, 1.0
  ),
  nrow = 4
)

data_frames <- list("A1" = Att_1, "A2" = Att_2, "A3" = Att_3, "Int" = intent)


### apply the function
my_correlated_scales <- correlateScales(
  dataframes = data_frames,
  scalecors = scale_cors
)
head(my_correlated_scales)

}
