% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLindley.R
\name{PLindley}
\alias{PLindley}
\alias{carbonfibres}
\alias{dplindley}
\alias{hplindley}
\alias{pplindley}
\alias{qplindley}
\alias{rplindley}
\title{Power Lindley Distribution}
\source{
[d-h-p-q-r]plindley are calculated directly from the definitions. \code{rplindley} uses either a two-component mixture of gamma distributions or the quantile function.
}
\usage{
dplindley(x, theta, alpha, log = FALSE)

pplindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qplindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE)

rplindley(n, theta, alpha, mixture = TRUE)

hplindley(x, theta, alpha, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha}{positive parameters.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mixture}{logical; If TRUE, (default), random deviates are generated from a two-component mixture of gamma distributions, otherwise from the quantile function.}
}
\value{
\code{dplindley} gives the density, \code{pplindley} gives the distribution function, \code{qplindley} gives the quantile function, \code{rplindley} generates random deviates and \code{hplindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the power Lindley distribution with parameters theta and alpha.
}
\details{
Probability density function
\deqn{f(x\mid \theta,\alpha )={\frac{\alpha \theta ^{2}}{1 + \theta}}(1+x^{\alpha})\ x^{\alpha -1}\ e^{-\theta x^{\alpha }}}

Cumulative distribution function
\deqn{F(x\mid \theta,\alpha )=1-\left( 1+{\frac{\theta }{1 + \theta}}x^{\alpha }\right) \ e^{-\theta x^{\alpha }}}

Quantile function
\deqn{Q(p\mid \theta,\alpha )=\left( -1-\frac{1}{\theta }-\frac{1}{\theta }W_{-1}\left( \left( 1+\theta \right) \left(p-1\right) e^{-(1+\theta) }\right) \right) ^{\frac{1}{\alpha }}}

Hazard rate function
\deqn{h(x\mid \theta ,\alpha )={\frac{\alpha \theta ^{2}(1+x^{\alpha })x^{\alpha-1}}{\left( \theta +1\right) \left( 1+{\frac{\theta }{\theta +1}}x^{\alpha }\right) }} }

where \eqn{W_{-1}} denotes the negative branch of the Lambert W function.

\bold{Particular case:} \eqn{\alpha = 1} the one-parameter Lindley distribution.
}
\examples{
set.seed(1)
x <- rplindley(n = 1000, theta = 1.5, alpha = 1.5, mixture = TRUE)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dplindley(S, theta = 1.5, alpha = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pplindley(q, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
pplindley(q, theta = 1.5, alpha = 1.5, lower.tail = FALSE)
qplindley(p, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
qplindley(p, theta = 1.5, alpha = 1.5, lower.tail = FALSE)

## carbon fibers data (from Ghitany et al., 2013)
data(carbonfibers)
library(fitdistrplus)
fit <- fitdist(carbonfibers, 'plindley', start = list(theta = 0.1, alpha = 0.1))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Ghitany, M. E., Al-Mutairi, D. K., Balakrishnan, N. and Al-Enezi, L. J., (2013). Power Lindley distribution and associated inference. \emph{Computational Statistics and Data Analysis}, \bold{64}, 20-33.

Mazucheli, J., Ghitany, M. E. and Louzada, F., (2013). Power Lindley distribution: Diferent methods of estimation and their applications to survival times data. \emph{Journal of Applied Statistical Science}, \bold{21}, (2), 135-144.
}
\seealso{
\code{\link[lamW]{lambertWm1}}, \code{\link[LindleyR]{DPLindley}}.
}

