% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual_predictive_equiv.R
\name{individual_predictive_equiv}
\alias{individual_predictive_equiv}
\title{individual_predictive_equiv function}
\usage{
individual_predictive_equiv(model_a, model_b, test_data, r = 0.1, alpha = 0.05)
}
\arguments{
\item{model_a}{logistic regression model \eqn{M_A}}

\item{model_b}{logistic regression model \eqn{M_B}}

\item{test_data}{testing dataset}

\item{r}{ratio of allowed 'flips' (defaults to 0.1)}

\item{alpha}{significance level \eqn{\alpha} (defaults to 0.05)}
}
\value{
\describe{
  \item{\code{equivalence}}{Are models \eqn{M_A,M_B} producing equivalent
      log-odds for the given test data? (boolean)}
  \item{\code{test_statistic}}{The test statistic}
  \item{\code{critical_value}}{a level-\eqn{\alpha} critical value the test}
  \item{\code{xi_bar}}{Mean \eqn{\xi} value for the test}
  \item{\code{delta_theta}}{Calculated equivalence parameter}
  \item{\code{p_value}}{P-value}
}
}
\description{
This function takes two logistic regression models \eqn{M_A, M_B},
    test data, significance level \eqn{\alpha} and allowed flips ratio
    \eqn{r}. It checks whether the models produce equivalent log-odds for
    the given test set and returns various figures.
}
