% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R08_LM.R
\name{FCI_R08}
\alias{FCI_R08}
\title{Hausman-type test for fractional cointegration (Robinson (2008))}
\usage{
FCI_R08(X, m, type = c("", "*", "**"), alpha = 0.05, a.vec = NULL)
}
\arguments{
\item{X}{data matrix.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies
used for the estimation, usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{type}{determines the implementation of the test statistic: \code{""} - real-valued, \code{"*"} - complex-valued, or \code{"**"} - complex-valued allowing for different memory parameters.}

\item{alpha}{desired significance level. Default is \code{alpha=0.05}.}

\item{a.vec}{weighting scheme for averaging univariate memory estimates, default is simple arithmetic mean.}
}
\description{
\code{FCI_R08} Semiparametric Hausmann-type test for fractional cointegration by Robinson (2008).
 Returns test statistic, critical value, testing decision and type. Null hypothesis: no fractional cointegration.
}
\examples{
T<-1000
series<-FI.sim(T=T, q=2, rho=0.9, d=c(0.1,0.4), B=rbind(c(1,-1),c(0,1)))
FCI_R08(series, m=floor(T^0.75), type="*")
series<-FI.sim(T=T, q=2, rho=0.9, d=c(0.4,0.4))
FCI_R08(series,  m=floor(T^0.75), type="*")
}
\references{
Robinson, P. (2008): Diagnostic testing for cointegration. Journal of Econometrics, Vol. 143, No. 1, pp. 206 - 225.
}
\author{
Christian Leschinski, Michelle Voges
}
