% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPWN.R
\name{LPWN}
\alias{LPWN}
\title{Local polynomial Whittle plus noise estimator}
\usage{
LPWN(data, m, R_short = 0, R_noise = 0)
}
\arguments{
\item{data}{data vector}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.}

\item{R_short}{number of (even) polynomial terms used for approximation of spectral density at the origin.}

\item{R_noise}{number of (even) polynomial terms used for approximation of dependence in perturbation term.}
}
\description{
\code{LPWN} calculates the local polynomial Whittle plus noise estimator of Frederiksen et al. (2012).
}
\details{
add details here.
}
\examples{
library(fracdiff)
T<-2000
d<-0.2
series<-fracdiff.sim(n=T, d=d, ar=0.6)$series+rnorm(T)
LPWN(series, m=floor(1+T^0.8), R_short=1, R_noise=0)
}
\references{
Frederiksen, P., Nielsen, F. S., and Nielsen, M. O. (2012): 
           Local polynomial Whittle estimation of perturbed fractional processes.
           Journal of Econometrics, Vol. 167, No.2, pp. 426-447.
}
