% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointegrating_rank_estimation.R
\name{rank.est}
\alias{rank.est}
\title{Cointegration Rank Estimation using Model Selection.}
\usage{
rank.est(data, d.hat, m, m1, v_n = m^(-0.3))
}
\arguments{
\item{data}{data matrix of dimension (qxT).}

\item{d.hat}{the estimated d.vector}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.
used for the estimation of d, usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{m1}{the bandwidth parameter used for estimation of d.vec with m1>>m}

\item{v_n}{bandwidth parameter. Nielsen and Shimotsu (2007) use m^(-0.3) in their 
simulation studies, which s the default value. m^(-b) mit 0<b<0.5 can be used.}
}
\description{
Model selection procedure to estimate the cointegrating rank 
             based on eigenvalues of correlation matrix P suggested by
             Robinson and Yajima (2002).
}
\details{
add details here.
}
\examples{
library(fracdiff)
T<-2000
d<-0.4
m1<-floor(1+T^0.75)
m<-floor(1+T^0.65)
xt<-fracdiff.sim(n=T, d=d)$series
yt<-xt+rnorm(T)
zt<-xt+rnorm(T)
X<-cbind(xt,yt,zt)
lW.wrap<-function(data,m){local.W(data,m)$d}
d.hat<-apply(X,2,lW.wrap, m=m1)
rank.est(data=X, d.hat, m=m, m1=m1)
}
\references{
Robinson, P. M. and Yajima, Y. (2002): Determination of cointegrating rank
           in fractional systems. Journal of Econometrics, Vol. 106, No.2, pp. 217-241. 
           
           Nielsen, M. O. and Shimotsu, K. (2007): Determining the coinegrating rank in 
           nonstationary fractional systems by the exact local Whittle approach. Journal of Econometrics,
           141, pp. 574-596.
}
