% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/merge_RLum.R
\name{merge_RLum}
\alias{merge_RLum}
\title{General merge function for RLum S4 class objects}
\usage{
merge_RLum(objects, ...)
}
\arguments{
\item{objects}{\code{\link{list}} of \code{\linkS4class{RLum}}
(\bold{required}): list of S4 object of class \code{RLum}}

\item{\dots}{further arguments that one might want to pass to the specific
merge function}
}
\value{
Return is the same as input objects as provided in the list.
}
\description{
Function calls object-specific merge functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for merge specific
\code{\linkS4class{RLum}} objects.\cr Depending on the input object, the
corresponding merge function will be selected.  Allowed arguments can be
found in the documentations of each merge function.
\tabular{lll}{
\bold{object} \tab \tab \bold{corresponding merge function} \cr

\code{\linkS4class{RLum.Results}} \tab : \tab
\code{merge_RLum} }
}
\note{
So far not for every \code{RLum} object a merging function exists.
}
\section{Function version}{
 0.1 (2015-07-23 17:09:29)
}
\examples{
##Example based using data and from the calc_CentralDose() function

##load example data
data(ExampleData.DeValues, envir = environment())

##apply the central dose model 1st time
temp1 <- calc_CentralDose(ExampleData.DeValues$CA1)

##apply the central dose model 2nd time
temp2 <- calc_CentralDose(ExampleData.DeValues$CA1)

##merge the results and store them in a new object
temp.merged <- get_RLum(merge_RLum(objects = list(temp1, temp2)))
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\references{
#
}
\seealso{
\code{\linkS4class{RLum.Results}},
}
\keyword{utilities}

