% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Results-class.R
\docType{class}
\name{RLum.Results-class}
\alias{RLum.Results-class}
\alias{get_RLum,RLum.Results-method}
\alias{length_RLum,RLum.Results-method}
\alias{names_RLum,RLum.Results-method}
\alias{set_RLum,RLum.Results-method}
\alias{show,RLum.Results-method}
\title{Class \code{"RLum.Results"}}
\usage{
\S4method{show}{RLum.Results}(object)

\S4method{set_RLum}{RLum.Results}(class, originator, data = list())

\S4method{get_RLum}{RLum.Results}(object, data.object, drop = TRUE)

\S4method{length_RLum}{RLum.Results}(object)

\S4method{names_RLum}{RLum.Results}(object)
}
\arguments{
\item{object}{[\code{get_RLum}] \code{\linkS4class{RLum.Results}} (required): an object of class
\code{\linkS4class{RLum.Results}} to be evaluated}

\item{class}{[\code{set_RLum}] \code{\link{character}} \bold{(required)}: name of the \code{RLum} class to create}

\item{originator}{[\code{set_RLum}] \code{\link{character}} (automatic): contains the
name of the calling function
(the function that produces this object); can be set manually.}

\item{data}{[\code{set_RLum}] \code{\link{list}} (optional): a list containing the data to
be stored in the object}

\item{data.object}{[\code{get_RLum}] \code{\link{character}} or
\code{\link{numeric}}: name or index of the data slot to be returned}

\item{drop}{[\code{get_RLum}] \code{\link{logical}} (with default): coerce to the next possible layer
(which are data objects, \code{drop = FALSE} keeps the original \code{RLum.Results}}
}
\value{
\bold{\code{set_RLum}}:\cr

Returns an object from the class \code{\linkS4class{RLum.Results}}\cr

\bold{\code{get_RLum}}:\cr

Returns: \cr
(1) Data object from the specified slot \cr
(2) \code{\link{list}} of data objects from the slots if 'data.object' is vector or \cr
(3) an \code{\linkS4class{RLum.Results}} for \code{drop = FALSE}.\cr

\bold{\code{length_RLum}}\cr

Returns the number of data elements in the \code{RLum.Results} object.

\bold{\code{names_RLum}}\cr

Returns the names of the data elements in the object.
}
\description{
Object class contains results data from functions (e.g. \code{\link{analyse_SAR.CWOSL}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Results} object

\item \code{set_RLum}: Construction method for an RLum.Results object.

\item \code{get_RLum}: Accessor method for RLum.Results object. The argument data.object allows
directly accessing objects delivered within the slot data. The default
return object depends on the object originator (e.g., \code{fit_LMCurve}).
If nothing is specified always the first \code{data.object} will be returned.

Note: Detailed specification should be made in combination with the originator slot in the
receiving function if results are pipped.

\item \code{length_RLum}: Returns the length of the object, i.e., number of stored data.objects

\item \code{names_RLum}: Returns the names data.objects
}}
\section{Slots}{

\describe{
\item{\code{data}}{Object of class "list" containing output data}
}}
\note{
The class is intended to store results from functions to be used by
other functions. The data in the object should always be accessed by the
method \code{get_RLum}.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("RLum.Results", ...)}.
}

\section{Class version}{
 0.4.0
}
\examples{

showClass("RLum.Results")

##create an empty object from this class
set_RLum(class = "RLum.Results")

##use another function to show how it works

##Basic calculation of the dose rate for a specific date
 dose.rate <-  calc_SourceDoseRate(
   measurement.date = "2012-01-27",
   calib.date = "2014-12-19",
   calib.dose.rate = 0.0438,
   calib.error = 0.0019)

##show object
dose.rate

##get results
get_RLum(dose.rate)

##get parameters used for the calcualtion from the same object
get_RLum(dose.rate, data.object = "parameters")

##alternatively objects can be accessed using S3 generics, such as
dose.rate$parameters

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
}
\seealso{
\code{\linkS4class{RLum}}, \code{\link{plot_RLum}}, \code{\link{merge_RLum}}
}
\keyword{classes}
\keyword{methods}

