% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Analysis.R
\name{plot_RLum.Analysis}
\alias{plot_RLum.Analysis}
\title{Plot function for an RLum.Analysis S4 class object}
\usage{
plot_RLum.Analysis(object, subset, nrows, ncols, abline = NULL,
  combine = FALSE, curve.transformation, plot.single = FALSE, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Analysis}} (\bold{required}): S4
object of class \code{RLum.Analysis}}

\item{subset}{named \code{\link{list}} (optional): subsets elements for plotting. The
arguments in the named \code{\link{list}} will be directly passed to the function \code{\link{get_RLum}}
(e.g., \code{subset = list(curveType = "measured")})}

\item{nrows}{\code{\link{integer}} (optional): sets number of rows for
plot output, if nothing is set the function tries to find a value.}

\item{ncols}{\code{\link{integer}} (optional): sets number of columns
for plot output, if nothing is set the function tries to find a value.}

\item{abline}{\code{\link{list}} (optional): allows to add ablines to the plot. Argument are provided
in a list and will be forwared to the function \code{\link{abline}}, e.g., \code{list(v = c(10, 100))}
adds two vertical lines add 10 and 100 to all plots. In contrast \code{list(v = c(10), v = c(100)}
adds a vertical at 10 to the first and a vertical line at 100 to the 2nd plot.}

\item{combine}{\code{\link{logical}} (with default): allows to combine all
\code{\linkS4class{RLum.Data.Curve}} objects in one single plot.}

\item{curve.transformation}{\code{\link{character}} (optional): allows
transforming CW-OSL and CW-IRSL curves to pseudo-LM curves via
transformation functions. Allowed values are: \code{CW2pLM}, \code{CW2pLMi},
\code{CW2pHMi} and \code{CW2pPMi}. See details.}

\item{plot.single}{\code{\link{logical}} (with default): global par settings are
considered, normally this should end in one plot per page}

\item{\dots}{further arguments and graphical parameters will be passed to
the \code{plot} function. Supported arguments: \code{main}, \code{mtext},
\code{log}, \code{lwd}, \code{lty} \code{type}, \code{pch}, \code{col},
\code{norm}, \code{xlim},\code{ylim}, \code{xlab}, \code{ylab}... and for \code{combine = TRUE}
also: \code{sub}, \code{legend}, \code{legend.text}, \code{legend.pos} (typical plus 'outside'), \code{legend.col}, \code{smooth}.
All arguments can be provided as \code{vector} or \code{list} to gain in full control
of all plot settings.}
}
\value{
Returns multiple plots.
}
\description{
The function provides a standardised plot output for curve data of an
RLum.Analysis S4 class object
}
\details{
The function produces a multiple plot output. A file output is recommended
(e.g., \code{\link{pdf}}).

\bold{curve.transformation}\cr

This argument allows transforming continuous wave (CW) curves to pseudo
(linear) modulated curves. For the transformation, the functions of the
package are used. Currently, it is not possible to pass further arguments to
the transformation functions. The argument works only for \code{ltype}
\code{OSL} and \code{IRSL}.\cr

Please note: The curve transformation within this functions works roughly,
i.e. every IRSL or OSL curve is transformed, without considerung whether it
is measured with the PMT or not! However, for a fast look it might be
helpful.\cr
}
\note{
Not all arguments available for \code{\link{plot}} will be passed!
Only plotting of \code{RLum.Data.Curve} and \code{RLum.Data.Spectrum}
objects are currently supported.\cr
}
\section{Function version}{
 0.3.6 (2016-09-01 11:17:26)
}
\examples{

##load data
data(ExampleData.BINfileData, envir = environment())

##convert values for position 1
temp <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos=1)

##plot (combine) TL curves in one plot
plot_RLum.Analysis(
temp,
subset = list(recordType = "TL"),
combine = TRUE,
norm = TRUE,
abline = list(v = c(110))
)

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\references{
#
}
\seealso{
\code{\link{plot}}, \code{\link{plot_RLum}},
\code{\link{plot_RLum.Data.Curve}}
}
\keyword{aplot}

