% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_AverageDose.R
\name{calc_AverageDose}
\alias{calc_AverageDose}
\title{Calculate the Average Dose and the dose rate dispersion}
\usage{
calc_AverageDose(data, sigma_m = NULL, Nb_BE = 500, na.rm = TRUE,
  plot = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{data}{\code{\linkS4class{RLum.Results}} or \link{data.frame}
(\bold{required}): for \code{data.frame}: two columns with De
\code{(data[,1])} and De error \code{(values[,2])}}

\item{sigma_m}{\code{\link{numeric}} (\bold{required}): the overdispersion resulting from a dose recovery
experiment, i.e. when all grains have  received the same dose. Indeed in such a case, any
overdispersion (i.e. dispersion on top of analytical uncertainties) is, by definition, an
unrecognised measurement uncertainty.}

\item{Nb_BE}{\code{\link{integer}} (with default): sample size used for the bootstrapping}

\item{na.rm}{\code{\link{logical}} (with default): exclude NA values
from the data set prior to any further operation.}

\item{plot}{\code{\link{logical}} (with default): enables/disables plot output}

\item{verbose}{\code{\link{logical}} (with default): enables/disables terminal output}

\item{...}{further arguments that can be passed to \code{\link[graphics]{hist}}. As three plots
are returned all arguments need to be provided as \code{\link{list}},
e.g., \code{main = list("Plot 1", "Plot 2", "Plot 3")}. Note: not all arguments of \code{hist} are
supported, but the output of \code{hist} is returned and can be used of own plots. \cr

Further supported arguments: \code{mtext} (\code{character}), \code{rug} (\code{TRUE/FALSE}).}
}
\description{
This functions calculates the Average Dose and their extrinsic dispersion and estimates
the standard errors by bootstrapping based on the Average Dose Model by Guerin et al., 2016
}
\details{
\bold{\code{sigma_m}}\cr

The program requires the input of a known value of sigma_m,
which corresponds to the intrinsic overdispersion, as determined
by a dose recovery experiment. Then the dispersion in doses (sigma_d)
will be that over and above sigma_m (and individual uncertainties sigma_wi).
}
\note{
This function has beta status!
}
\section{Function version}{
 0.1.3 (2017-01-24 21:10:47)
}

\examples{

##Example 01 using package example data
##load example data
data(ExampleData.DeValues, envir = environment())

##calculate Average dose
##(use only the first 56 values here)
AD <- calc_AverageDose(ExampleData.DeValues$CA1[1:56,],
sigma_m = 0.1)

##plot De and set Average dose as central value
plot_AbanicoPlot(
 data = ExampleData.DeValues$CA1[1:56,],
 z.0 = AD$summary$Average_DOSE)

} 

\section{How to cite}{
Christophe, C., Philippe, A., Guerin, G., Kreutzer, S. (2017). calc_AverageDose(): Calculate the Average Dose and the dose rate dispersion. Function version 0.1.3. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.0. https://CRAN.R-project.org/package=Luminescence
}

\references{
TODO: Add Guerin et al., 2016 once it has been published

\bold{Further reading}\cr

Efron, B., Tibshirani, R., 1986. Bootstrap Methods for Standard Errors, Confidence Intervals,
and Other Measures of Statistical Accuracy. Statistical Science 1, 54-75.
}
\seealso{
\code{\link{read.table}}, \code{\link[graphics]{hist}}
}
\author{
Claire Christophe, IRAMAT-CRP2A, Universite de Nantes (France),
Anne Philippe, Universite de Nantes, (France),
Guillaume Guerin, IRAMAT-CRP2A, Universite Bordeaux Montaigne, (France),
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne, (France)
\cr R Luminescence Package Team}
\keyword{datagen}
