% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{ExampleData.Al2O3C}
\alias{ExampleData.Al2O3C}
\title{Example Al2O3:C Measurement Data}
\format{Two datasets comprising \linkS4class{RLum.Analysis} data imported using the function \link{read_XSYG2R}

\describe{
\code{data_ITC}: Measurement data to determine the irradiation time correction, the data can
be analysed with the function \link{analyse_Al2O3C_ITC}

\code{data_CrossTalk}: Measurement data obtained while estimating the irradiation cross-talk of the
reader used for the experiments. The data can be analysed either with the function
\link{analyse_Al2O3C_CrossTalk} or \link{analyse_Al2O3C_Measurement}
}}
\description{
Measurement data obtained from measuring Al2O3:C chips at the IRAMAT-CRP2A, Université Bordeaux
Montainge in 2017 on a Freiberg Instruments lexsyg SMART reader.
The example data used in particular to allow test of the functions
developed in framework of the work by Kreutzer et al., 2018.
}
\note{
From both datasets unneeded curves have been removed and
the number of aliquots have been reduced to a required minimum to keep the file size small, but
still being able to run the corresponding functions.
}
\examples{

##(1) curves
data(ExampleData.Al2O3C, envir = environment())
plot_RLum(data_ITC[1:2])

}
\references{
Kreutzer et al., 2018 (TODO)
}
\seealso{
\link{analyse_Al2O3C_ITC}, \link{analyse_Al2O3C_CrossTalk}, \link{analyse_Al2O3C_Measurement}
}
\keyword{datasets}
