% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Results-class.R
\docType{class}
\name{RLum.Results-class}
\alias{RLum.Results-class}
\alias{show,RLum.Results-method}
\alias{set_RLum,RLum.Results-method}
\alias{get_RLum,RLum.Results-method}
\alias{length_RLum,RLum.Results-method}
\alias{names_RLum,RLum.Results-method}
\title{Class \code{"RLum.Results"}}
\usage{
\S4method{show}{RLum.Results}(object)

\S4method{set_RLum}{RLum.Results}(class, originator, .uid, .pid, data = list(), info = list())

\S4method{get_RLum}{RLum.Results}(object, data.object, info.object = NULL, drop = TRUE)

\S4method{length_RLum}{RLum.Results}(object)

\S4method{names_RLum}{RLum.Results}(object)
}
\arguments{
\item{object}{\code{\link{get_RLum}}; \linkS4class{RLum.Results} (\strong{required}):
an object of class \linkS4class{RLum.Results} to be evaluated}

\item{class}{\code{\link{set_RLum}}; \link{character} \strong{(required)}:
name of the \code{RLum} class to create}

\item{originator}{\code{\link{set_RLum}}; \link{character} (\emph{automatic}):
contains the name of the calling function (the function that produces this object);
can be set manually.}

\item{.uid}{\code{\link{set_RLum}}; \link{character} (\emph{automatic}):
sets an unique ID for this object using the internal C++ function \code{create_UID}.}

\item{.pid}{\code{\link{set_RLum}}; \link{character} (\emph{with default}):
option to provide a parent id for nesting at will.}

\item{data}{\code{\link{set_RLum}}; \link{list} (\emph{optional}):
a list containing the data to
be stored in the object}

\item{info}{\code{\link{set_RLum}}; \link{list} (\emph{optional}):
a list containing additional info data for the object}

\item{data.object}{\code{\link{get_RLum}}; \link{character} or \link{numeric}:
name or index of the data slot to be returned}

\item{info.object}{\code{\link{get_RLum}}; \link{character} (\emph{optional}):
name of the wanted info element}

\item{drop}{\code{\link{get_RLum}}; \link{logical} (\emph{with default}):
coerce to the next possible layer (which are data objects, \code{drop = FALSE}
keeps the original \code{RLum.Results}}
}
\value{
\strong{\code{set_RLum}}:

Returns an object from the class \linkS4class{RLum.Results}

\strong{\code{get_RLum}}:

Returns:
\enumerate{
\item Data object from the specified slot
\item \link{list} of data objects from the slots if 'data.object' is vector or
\item an \linkS4class{RLum.Results} for \code{drop = FALSE}.
}

\strong{\code{length_RLum}}

Returns the number of data elements in the \code{RLum.Results} object.

\strong{\code{names_RLum}}

Returns the names of the data elements in the object.
}
\description{
Object class contains results data from functions (e.g., \link{analyse_SAR.CWOSL}).
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Results} object

\item \code{set_RLum}: Construction method for an RLum.Results object.

\item \code{get_RLum}: Accessor method for RLum.Results object. The argument data.object allows
directly accessing objects delivered within the slot data. The default
return object depends on the object originator (e.g., \code{fit_LMCurve}).
If nothing is specified always the first \code{data.object} will be returned.

Note: Detailed specification should be made in combination with the originator slot in the
receiving function if results are pipped.

\item \code{length_RLum}: Returns the length of the object, i.e., number of stored data.objects

\item \code{names_RLum}: Returns the names data.objects
}}

\section{Slots}{

\describe{
\item{\code{data}}{Object of class \link{list} containing output data}
}}

\note{
The class is intended to store results from functions to be used by
other functions. The data in the object should always be accessed by the
method \code{get_RLum}.
}
\section{Objects from the Class}{

Objects can be created by calls of the form \code{new("RLum.Results", ...)}.
}

\section{Class version}{
 0.5.2
}

\examples{

showClass("RLum.Results")

##create an empty object from this class
set_RLum(class = "RLum.Results")

##use another function to show how it works

##Basic calculation of the dose rate for a specific date
 dose.rate <-  calc_SourceDoseRate(
   measurement.date = "2012-01-27",
   calib.date = "2014-12-19",
   calib.dose.rate = 0.0438,
   calib.error = 0.0019)

##show object
dose.rate

##get results
get_RLum(dose.rate)

##get parameters used for the calcualtion from the same object
get_RLum(dose.rate, data.object = "parameters")

##alternatively objects can be accessed using S3 generics, such as
dose.rate$parameters

}
\seealso{
\linkS4class{RLum}, \link{plot_RLum}, \link{merge_RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2022. RLum.Results-class(): Class 'RLum.Results'. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.20. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
\keyword{internal}
\keyword{methods}
