% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_IEU.R
\name{calc_IEU}
\alias{calc_IEU}
\title{Apply the internal-external-uncertainty (IEU) model after Thomsen et al.
(2007) to a given De distribution}
\usage{
calc_IEU(data, a, b, interval, decimal.point = 2, plot = TRUE, ...)
}
\arguments{
\item{data}{\linkS4class{RLum.Results} or \link{data.frame} (\strong{required}):
for \link{data.frame}: two columns with De \code{(data[,1])} and
De error \code{(values[,2])}}

\item{a}{\link{numeric} (\strong{required}):
slope}

\item{b}{\link{numeric} (\strong{required}):
intercept}

\item{interval}{\link{numeric} (\strong{required}):
fixed interval (e.g. 5 Gy) used for iteration of Dbar, from the mean to
Lowest.De used to create Graph.IEU \verb{[Dbar.Fixed vs Z]}}

\item{decimal.point}{\link{numeric} (\emph{with default}):
number of decimal points for rounding calculations (e.g. 2)}

\item{plot}{\link{logical} (\emph{with default}):
plot output}

\item{...}{further arguments (\verb{trace, verbose}).}
}
\value{
Returns a plot (\emph{optional}) and terminal output. In addition an
\linkS4class{RLum.Results} object is returned containing the
following elements:

\item{.$summary}{\link{data.frame} summary of all relevant model results.}
\item{.$data}{\link{data.frame} original input data}
\item{.$args}{\link{list} used arguments}
\item{.$call}{\link{call} the function call}
\item{.$tables}{\link{list} a list of data frames containing all calculation tables}

The output should be accessed using the function \link{get_RLum}.
}
\description{
Function to calculate the IEU De for a De data set.
}
\details{
This function uses the equations of Thomsen et al. (2007). The parameters a
and b are estimated from dose-recovery experiments.
}
\section{Function version}{
 0.1.1
}

\examples{

## load data
data(ExampleData.DeValues, envir = environment())

## apply the IEU model
ieu <- calc_IEU(ExampleData.DeValues$CA1, a = 0.2, b = 1.9, interval = 1)

} 

\section{How to cite}{
Smedley, R.K., 2020. calc_IEU(): Apply the internal-external-uncertainty (IEU) model after Thomsen et al. (2007) to a given De distribution. Function version 0.1.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Riedesel, S., Autzen, M., Mittelstrass, D., 2020. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.9. https://CRAN.R-project.org/package=Luminescence
}

\references{
Smedley, R.K., 2015. A new R function for the Internal External Uncertainty (IEU) model.
Ancient TL 33, 16-21.

Thomsen, K.J., Murray, A.S., Boetter-Jensen, L. & Kinahan, J.,
2007. Determination of burial dose in incompletely bleached fluvial samples
using single grains of quartz. Radiation Measurements 42, 370-379.
}
\seealso{
\link{plot}, \link{calc_CommonDose}, \link{calc_CentralDose}, \link{calc_FiniteMixture},
\link{calc_FuchsLang2001}, \link{calc_MinDose}
}
\author{
Rachel Smedley, Geography & Earth Sciences, Aberystwyth University (United Kingdom) \cr
Based on an excel spreadsheet and accompanying macro written by Kristina Thomsen.
, RLum Developer Team}
