% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_RLum2Risoe.BINfileData.R
\name{convert_RLum2Risoe.BINfileData}
\alias{convert_RLum2Risoe.BINfileData}
\title{Converts RLum.Analysis and RLum.Data.Curve objects to RLum2Risoe.BINfileData objects}
\usage{
convert_RLum2Risoe.BINfileData(object, keep.position.number = FALSE)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} or \linkS4class{RLum.Data.Curve} (\strong{required}): input object to
be converted}

\item{keep.position.number}{\link{logical} (\emph{with default}): keeps the original
position number or re-calculate the numbers to avoid doubling}
}
\value{
The function returns a \linkS4class{Risoe.BINfileData} object.
}
\description{
The functions converts \linkS4class{RLum.Analysis} and
\linkS4class{RLum.Data.Curve} objects (or a \link{list} of such objects) to
\linkS4class{Risoe.BINfileData} objects. The function intends to provide a
minimum of compatibility between both formats. The created
\linkS4class{RLum.Analysis} object can be later exported to a BIN-file using
function \link{write_R2BIN}.
}
\note{
The conversion can be never perfect. The \code{RLum} objects may contain information which are
not part of the \linkS4class{Risoe.BINfileData} definition.
}
\section{Function version}{
 0.1.4
}

\examples{

##simple conversion using the example dataset
data(ExampleData.RLum.Analysis, envir = environment())
convert_RLum2Risoe.BINfileData(IRSAR.RF.Data)

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve}, \link{write_R2BIN}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. convert_RLum2Risoe.BINfileData(): Converts RLum.Analysis and RLum.Data.Curve objects to RLum2Risoe.BINfileData objects. Function version 0.1.4. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\keyword{IO}
