/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ui.NodeSetTableModel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapeResultViewerPanel;

public class FindAction
extends AbstractAction {
    protected CytoscapeResultViewerPanel resultViewer;

    public FindAction(CytoscapeResultViewerPanel panel) {
        super("Find clusters of this node");
        this.resultViewer = panel;
        this.putValue("MnemonicKey", 70);
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("../../resources/find.png")));
        this.putValue("ShortDescription", "Select all the clusters corresponding to the selected nodes in the result panel");
    }

    public void actionPerformed(ActionEvent event) {
        CyNetwork network = this.resultViewer.getNetwork();
        if (network == null) {
            return;
        }
        Set selectedNodes = network.getSelectedNodes();
        List<Node> nodeMapping = this.resultViewer.getNodeMapping();
        HashSet<Integer> selectedIndices = new HashSet<Integer>();
        for (Node node : selectedNodes) {
            int pos = nodeMapping.indexOf(node);
            if (pos < 0) continue;
            selectedIndices.add(pos);
        }
        ArrayList<Integer> selectedRowIndices = new ArrayList<Integer>();
        NodeSetTableModel model = this.resultViewer.getTableModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            NodeSet nodeSet = model.getNodeSetByIndex(row);
            if (!nodeSet.containsAny(selectedIndices)) continue;
            selectedRowIndices.add(row);
        }
        this.resultViewer.setSelectedNodeSetIndices(selectedRowIndices);
    }
}

