% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTCGAComparePlot.R
\name{generateTCGAComparePlot}
\alias{generateTCGAComparePlot}
\title{Plot the comparison of the mutation load against TCGA cohorts}
\source{
TCGA MC3 file was obtained from  https://api.gdc.cancer.gov/data/1c8cfe5f-e52d-41ba-94da-f15ea1337efc. See TCGAmutations R package for more details. Further downstream script to estimate TMB for each sample can be found in ‘inst/scripts/estimate_tcga_tmb.R’
}
\usage{
generateTCGAComparePlot(
  maf,
  capture_size = NULL,
  tcga_capture_size = 35.8,
  cohortName = NULL,
  tcga_cohorts = NULL,
  primarySite = FALSE,
  col = c("gray70", "black"),
  medianCol = "red",
  decreasing = FALSE,
  logscale = TRUE,
  rm_hyper = FALSE,
  rm_zero = TRUE
)
}
\arguments{
\item{maf}{A MAF object}

\item{capture_size}{capture size for input MAF in MBs. Default NULL. If provided plot will be scaled to mutations per MB}

\item{tcga_capture_size}{capture size for TCGA cohort in MB. Default 35.8.}

\item{cohortName}{name for the input MAF cohort. Default "Input"}

\item{tcga_cohorts}{restrict tcga data to these cohorts.}

\item{primarySite}{If TRUE uses primary site of cancer as labels instead of TCGA project IDs. Default FALSE.}

\item{col}{color vector for length 2 TCGA cohorts and input MAF cohort. Default gray70 and black.}

\item{medianCol}{color for median line. Default red.}

\item{decreasing}{Default FALSE. Cohorts are arranged in increasing mutation burden.}

\item{logscale}{Default TRUE}

\item{rm_hyper}{Remove hyper mutated samples (outliers)? Default FALSE}

\item{rm_zero}{Remove samples with zero mutations? Default TRUE}
}
\value{
A list consisting of median mutations per cohort, mutation burden per cohort,
significant differences between cohorts, and ggplot object to show mutation burden plot
}
\description{
This function computes and plot the mutation load of the input MAF against all of 33 TCGA cohorts derived from MC3 project.
}
\details{
Tumor mutation burden for TCGA cohorts is obtained from TCGA MC3 study. For consistency TMB is estimated by restricting variants within Agilent Sureselect capture kit of size 35.8 MB.
}
\examples{
library(maftools)
library(MAFDash)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
maf <- read.maf(maf = maf)
l<-generateTCGAComparePlot(maf = maf, cohortName = "test")
l$tcga_compare_plot
}
\references{
Scalable Open Science Approach for Mutation Calling of Tumor Exomes Using Multiple Genomic Pipelines Kyle Ellrott, Matthew H. Bailey, Gordon Saksena, et. al. Cell Syst. 2018 Mar 28; 6(3): 271–281.e7. https://doi.org/10.1016/j.cels.2018.03.002
}
\author{
Ashish Jain, Mayank Tandon
}
