% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_repseq.R
\name{join_repseq}
\alias{join_repseq}
\title{Join Representative Sequences}
\usage{
join_repseq(mcl_data, fa_dir, mcl_mtrx, fastaformat = "new")
}
\arguments{
\item{mcl_data}{output of format_afterOrtho() --list of 2 things-- 1: binary matrix indicating the presence / absence of genes in each OG and 2: vector of names of OGs}

\item{fa_dir}{Path to the directory where all raw GenBank files are stored. Note, all file names must be changed to a 4-letter code representing each species and have '.fasta' file descriptor}

\item{mcl_mtrx}{OrthoMCL output matrix from analyze_OrthoMCL()}

\item{fastaformat}{options: new & old; defaults to old; takes care of NCBI updated fasta headers}
}
\value{
Returns the original OrthoMCL output matrix with additional columns: representative sequence taxon, representative sequence id, representative sequence annotation, representative sequence
}
\description{
Joins the OrthoMCL output matrix to representative sequences
}
\examples{

dir <- system.file('extdata', 'fasta_dir', package='MAGNAMWAR')
dir <- paste(dir,'/',sep='')
joined_mtrx_grps <- join_repseq(after_ortho_format_grps, dir, mcl_mtrx_grps, fastaformat = 'old')

}
