% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{pseudo}
\alias{print.pseudo}
\alias{pseudo}
\alias{pseudo.default}
\alias{summary.pseudo}
\title{The pseudo-causal model function}
\usage{
pseudo(y, x, p)

\method{pseudo}{default}(y, x, p)

\method{print}{pseudo}(x, ...)

\method{summary}{pseudo}(object, ...)
}
\arguments{
\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{p}{Number of lags to be included.}

\item{...}{Other arguments}

\item{object}{An object of the class "pseudo"}
}
\value{
An object of class \code{"pseudo"} is a list containing the following components:

\item{coefficients}{Vector of estimated coefficients.}

\item{coef.auto}{Vector of estimated autoregressive parameters.}

\item{coef.exo}{Vector of estimated exogenous parameters.}

\item{mse}{Mean squared error.}

\item{residuals}{Residuals.}

\item{loglikelihood}{Value of the loglikelihood.}

\item{fitted.values}{Fitted values.}

\item{df}{Degrees of freedom.}

\item{vcov}{Variance-covariance matrix of residuals.}
}
\description{
This function allows you to estimate pseudo-causal ARX models by OLS (compatible with most functions in lm() class).
}
\examples{
data <- sim.marx(c('t',1,1), c('t',1,1),100,0.5,0.4,0.3)
object <- pseudo(data$y, data$x, 2)
class(object) <- "pseudo"
summary(object)
}
\keyword{estimation}
\keyword{pseudo-causal}

