% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{MAZE}
\alias{MAZE}
\title{Mediation Analysis for ZEro-inflated mediators}
\usage{
MAZE(
  data,
  distM = c("zilonm", "zinbm", "zipm"),
  K = 1,
  selection = "AIC",
  X,
  M,
  Y,
  Z = NULL,
  XMint = c(TRUE, FALSE),
  x1,
  x2,
  zval = NULL,
  mval = 0,
  B = 20,
  seed = 1,
  ncore = 1
)
}
\arguments{
\item{data}{a data frame containing variables: an independent variable X, a mediator M, an outcome Y, and confounder variables Z (if any). See example dataset: data(zinb10)}

\item{distM}{an optional character value for distribution to be used for the mediator. Possible choices are 'zilonm', 'zinbm', or 'zipm' for zero-inflated log-normal, negative binomial, or Poisson mediators respectively. By default, all three distributions will be fitted and the final mediation model is selected by AIC}

\item{K}{a user supplied sequence for the number of component K in the zero-inflated mixture mediators. Default is K = 1 for zero-inflated non-mixture mediators}

\item{selection}{model selection criterion to be used when more than one model is fitted. Possible choices are 'AIC' and 'BIC'. Default is 'AIC'}

\item{X}{name of the independent variable}

\item{M}{name of the mediator variable}

\item{Y}{name of the outcome variable}

\item{Z}{name(s) of confounder variables}

\item{XMint}{a logical vector of length 2 indicating whether to include the interaction terms between (i) X and 1(M>0) and (ii) X and M. Default is c(TRUE, FALSE)}

\item{x1}{the first value of independent variable of interest}

\item{x2}{the second value of independent variable of interest}

\item{zval}{the value of confounders to be conditional on in estimating effects}

\item{mval}{the fixed value of mediator to be conditional on in estimating CDE}

\item{B}{the upper bound value B to be used in the probability mechanism of observing false zeros}

\item{seed}{an optional seed number to control randomness}

\item{ncore}{number of cores available for parallel computing}
}
\value{
a list containing:
\itemize{
\item results_effects: a data frame for the results of estimated effects,
\item results_parameters: a data frame for the results of model parameters,
\item selected_model_name: a string for the distribution of M and number of components K selected in the final mediation model
\item BIC: a numeric value for the BIC of the final mediation model,
\item AIC: a numeric value for the AIC of the final mediation model,
\item models: a list with all fitted models
\item analysis2_out: a list with output from analysis2() function (used for internal check)
}
}
\description{
A novel mediation modeling approach to address zero-inflated mediators containing true zeros and false zeros.
}
\details{
For an independent variable \eqn{X}, a zero-inflated mediator \eqn{M} and a continuous outcome variable \eqn{Y}, the following regression equation is used to model the association between \eqn{Y} and \eqn{(X,M)}:
\deqn{Y_{xm1_{(m>0)}}=\beta_0+\beta_1m+\beta_2 1_{(m>0)}+\beta_3x+\beta_4x1_{(m>0)}+\beta_5xm+\epsilon}
}
\examples{
data(zinb10)
\donttest{
maze_out <- MAZE(data=zinb10,
distM=c('zilonm', 'zinbm', 'zipm'),
K = 1,
selection = 'AIC',
X='X', M='Mobs', Y='Y', Z=NULL,
XMint = c(TRUE, FALSE),
x1=0, x2=1, zval = NULL, mval = 0,
B=20, seed=1)
## results of selected mediation model
maze_out$results_effects # indirect and direct effects
maze_out$results_parameters # model parameters
maze_out$BIC; maze_out$AIC # BIC and AIC of the selected mediation model
maze_out$selected_disM # distribution of the mediator in the selected mediation model
}
}
\author{
Zhigang Li \href{mailto:zhigang.li@ufl.edu}{zhigang.li@ufl.edu}
Meilin Jiang \href{mailto:meilin.jiang@ufl.edu}{meilin.jiang@ufl.edu}
}
